% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_test_data}
\alias{simulate_test_data}
\alias{as_vcov}
\title{Create simulated datasets}
\usage{
simulate_test_data(
  n = 200,
  sd = c(3, 5, 7),
  cor = c(0.1, 0.7, 0.4),
  mu = list(int = 10, age = 3, sex = 2, trt = c(0, 4, 8), visit = c(0, 1, 2))
)

as_vcov(sd, cor)
}
\arguments{
\item{n}{the number of subjects to sample. Total number of observations returned
is thus \code{n * length(sd)}}

\item{sd}{the standard deviations for the outcome at each visit.
i.e. the square root of the diagonal of the covariance matrix for the outcome}

\item{cor}{the correlation coefficients between the outcome values at each visit.
See details.}

\item{mu}{the coefficients to use to construct the mean outcome value at each visit. Must
be a named list with elements \code{int}, \code{age}, \code{sex}, \code{trt} & \code{visit}. See details.}
}
\description{
Creates a longitudinal dataset in the format that \code{rbmi} was
designed to analyse.
}
\details{
The number of visits is determined by the size of the variance covariance matrix.
i.e. if 3 standard deviation values are provided then 3 visits per patient will be
created.

The covariates in the simulated dataset are produced as follows:
\itemize{
\item Patients age is sampled at random from a N(0,1) distribution
\item Patients sex is sampled at random with a 50/50 split
\item Patients group is sampled at random but fixed so that each group has \code{n/2} patients
\item The outcome variable is sampled from a multivariate normal distribution, see below
for details
}

The mean for the outcome variable is derived as:\preformatted{outcome = Intercept + age + sex + visit + treatment
}

The coefficients for the intercept, age and sex are taken from \code{mu$int},
\code{mu$age} and \code{mu$sex} respectively, all of which must be a length 1 numeric.

Treatment and visit coefficients are taken from \code{mu$trt} and \code{mu$visit} respectively
and must either be of length 1 (i.e. a constant affect across all visits) or equal to the
number of visits (as determined by the length of \code{sd}). I.e. if you wanted a treatment
slope of 5 and a visit slope of 1 you could specify:\preformatted{mu = list(..., "trt" = c(0,5,10), "visit" = c(0,1,2))
}

The correlation matrix is constructed from \code{cor} as follows.
Let \code{cor = c(a, b, c, d, e, f)} then the correlation matrix would be:\preformatted{1  a  b  d
a  1  c  e
b  c  1  f
d  e  f  1
}
}
