# rbmi 1.5.1

## Bug Fixes

* Modify caching in tests to speed up testing on CRAN.

# rbmi 1.5.0

## New Features

* All covariance structures are now also supported for Bayesian multiple imputation: `method_bayes()` gained additional `covariance` and `prior_cov` arguments to allow users to specify the covariance structure and prior for the Bayesian imputation model. Please see the updated statistical specifications vignette for details. (#501, #518)
* New function `mcse()` to calculate the Monte Carlo standard error for pooled estimates from (approximate) Bayesian imputation. (#493)

## Bug Fixes

* Fixed cluster used in parallel test and make sure tests clean up Stan files properly. (#523)
* Small updates and fixes to documentation. (#504, #506, #498)

# rbmi 1.4.1

## Bug Fixes

* Fixed Stan related bug that caused unit tests to fail on machines compiling with the C23 standard (#481)
* Fixed bug in unit test that caused false-positive reproducibility errors (#483)

# rbmi 1.4.0

## Breaking Changes

* Deprecated the `burn_in` and `burn_between` arguments in `method_bayes()` in favour of using the `warmup` and `thin` arguments, respectively, in the new `control` list produced by `control_bayes`. This is to align with the `rstan` package. (#477)

## New Features

* Added `control_bayes()` function to allow expert users to specify additional control arguments for the MCMC computations using `rstan`. (#477)

## Bug Fixes

* Fixed bug where `lsmeans(.weights = "proportional_em")` would error if there was only a single categorical variable in the dataset. (#412)
* Removed native pipes `|>` and lambda functions `\(x)` from code base to ensure package is backwards compatible with older versions of R. (#474)

# rbmi 1.3.1

* Fixed bug where stale caches of the `rstan` model were not being correctly cleared (#459)

# rbmi 1.3.0

## Breaking Changes

* Convert `rstan` to be a suggested package to simplify the installation process. This means that the Bayesian imputation functionality will not be available by default. To use this feature, you will need to install `rstan` separately (#441)
* Deprecated the `seed` argument to `method_bayes()` in favour of using the base `set.seed()` function (#431)

## New Features

* Added vignette on how to implement retrieved dropout models with time-varying intercurrent event (ICE) indicators (#414)
* Added vignette on how to obtain frequentist and information-anchored inference with conditional mean imputation using `rbmi` (#406)
* Added FAQ vignette including a statement on validation (#407 #440)
* Updates to `lsmeans()` for better consistency with the `emmeans` package (#412)
    * Renamed `lsmeans(..., weights = "proportional")` to `lsmeans(..., weights = "counterfactual")`to more accurately reflect the weights used in the calculation.
    * Added `lsmeans(..., weights = "proportional_em")` which provides consistent results with `emmeans(..., weights = "proportional")`
    * `lsmeans(..., weights = "proportional")` has been left in the package for backwards compatibility and is an alias for `lsmeans(..., weights = "counterfactual")` but now gives
    a message prompting users to use either "proptional_em" or "counterfactual" instead.
* Added support for parallel processing in the `analyse()` function (#370)
* Added documentation clarifying potential false-positive warnings from rstan (#288)
* Added support for all covariance structures supported by the `mmrm` package (#437)
* Updated `rbmi` citation detail (#423 #425)

## Miscellaneous Bug Fixes

* Stopped warning messages being accidentally supressed when changing the ICE type in `impute()` (#408)
* Fixed equations not rendering properly in the `pkgdown` website (#433) 

# rbmi 1.2.6

* Updated unit tests to fix false-positive error on CRAN's testing servers

# rbmi 1.2.5

* Updated internal Stan code to ensure future compatibility (@andrjohns, #390)
* Updated package description to include relevant references (#393)
* Fixed documentation typos (#393)

# rbmi 1.2.3

* Minor internal tweaks to ensure compatibility with the packages `rbmi` depends on

# rbmi 1.2.1

* Removed native pipes `|>` in testing code so package is backwards compatible with older servers
* Replaced our `glmmTMB` dependency with the `mmrm` package. This has resulted in the package being more stable (less model fitting convergence issues) as well as speeding up run times 3-fold. 

# rbmi 1.1.4

* Updated urls for references in vignettes
* Fixed a bug where visit factor levels were re-constructed incorrectly in `delta_template()`
* Fixed a bug where the wrong visit was displayed in the error message for when a specific visit doesn't have any data in `draws()`
* Fixed a bug where the wrong input parameter was displayed in an error message in `simulate_data()`
  
# rbmi 1.1.1 & 1.1.3
 
* No change in functionality from 1.1.0
* Various minor tweaks to address CRAN checks messages
  
# rbmi 1.1.0
  
* Initial public release
