% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_imputed_data}
\alias{get_imputed_data}
\title{Get Imputed Data Sets as a data frame}
\usage{
get_imputed_data(impute_obj)
}
\arguments{
\item{impute_obj}{The imputation object from which the imputed datasets are extracted.}
}
\value{
A data frame with the original subject IDs mapped and renamed.
}
\description{
This function takes an imputed dataset and a mapping variable to return a dataset
with the original IDs mapped back and renamed appropriately.
}
\examples{
\donttest{
library(dplyr)
library(rbmi)
library(rbmiUtils)

set.seed(1974)
# Load example dataset
data("ADEFF")

# Prepare data
ADEFF <- ADEFF |>
  mutate(
    TRT = factor(TRT01P, levels = c("Placebo", "Drug A")),
    USUBJID = factor(USUBJID),
    AVISIT = factor(AVISIT)
  )

# Define variables for imputation
vars <- set_vars(
  subjid = "USUBJID",
  visit = "AVISIT",
  group = "TRT",
  outcome = "CHG",
  covariates = c("BASE", "STRATA", "REGION")
)

# Define Bayesian imputation method
method <- method_bayes(
  n_samples = 100,
  control = control_bayes(warmup = 200, thin = 2)
)

# Generate draws and perform imputation
draws_obj <- draws(data = ADEFF, vars = vars, method = method)
impute_obj <- impute(draws_obj,
  references = c("Placebo" = "Placebo", "Drug A" = "Placebo"))

# Extract imputed data with original subject IDs
admi <- get_imputed_data(impute_obj)
head(admi)
}
}
