% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_callback.R
\name{custom_callback}
\alias{custom_callback}
\title{Specify a custom callback}
\usage{
custom_callback(code, lnames = NULL, args = NULL)
}
\arguments{
\item{code}{a string of javascript callback code}

\item{lnames}{vector of layer names to be made available inside the callback in addition to the default callback objects (see details)}

\item{args}{named list of additional references to objects to be addressable in the callback}
}
\description{
This registers a callback that allows you to specify your own custom callback javascript code.  A probalby more useful callback to use in conjunction with this for working on the javascript code is the \code{\link{debug_callback}} which will place you inside a debugger in your web browser allowing you to inspect the callback objects.
}
\details{
If we add a layer and provide it, for example the \code{lname} "points", then if we refer to it using the \code{lnames} parameter to the callback, several objects will be made available inside the callback for you to access, given the names "points_data", "points_glyph", "points_glyph_rend", "points_hov_glyph", "points_ns_glyph", all pointers to different objects associated with the "points" layer that your callback can manipulate.
}
\examples{
\donttest{
# hover over the blue points and make the orange points move
figure(title = "hover a blue point") \%>\%
  ly_points(1:10, lname = "blue", lgroup = "g1") \%>\%
  ly_points(2:12, lname = "orange", lgroup = "g1") \%>\%
  tool_hover(custom_callback(
    code = "debugger;if(cb_data.index['1d'].indices.length > 0)
    orange_data.get('data').x[cb_data.index['1d'].indices] += 0.1
    orange_data.trigger('change')", "orange"), "blue")
}
}
