% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridge.R
\name{bridge}
\alias{bridge}
\title{Fit a Bridge Estimation}
\usage{
bridge(X, y, q = 1, lambda.min = ifelse(n > p, 0.001, 0.05),
  nlambda = 100, lambda, eta = 1e-07, converge = 10^10)
}
\arguments{
\item{X}{Design matrix.}

\item{y}{Response vector.}

\item{q}{is the degree of norm which includes ridge regression with \code{q=2} and lasso estimates with \code{q=1} as special cases}

\item{lambda.min}{The smallest value for lambda if \code{n>p} is \code{0.001} and \code{0.05} otherwise.}

\item{nlambda}{The number of lambda values - default is \code{100}}

\item{lambda}{A user supplied lambda sequence. By default, the program compute a squence of values the length of nlambda.}

\item{eta}{is a preselected small positive threshold value. It is deleted \code{jth} variable to make the algorithm stable and also is excluded \code{jth} variable from the final model. Default is \code{1e-07}.}

\item{converge}{is the value of converge. Defaults is \code{10^10}. In each iteration, it is calculated by sum of square the change in linear predictor for each coefficient. The algorithm iterates until \code{converge > eta}.}
}
\value{
An object of class rbridge, a list with entries
\item{betas}{Coefficients computed over the path of lambda}
\item{lambda}{The lambda values which is given at the function}
}
\description{
Fit a bridge penalized maximum likelihood.
It is computed the regularization path which is consisted of \code{lasso} or \code{ridge} penalty 
at the a grid values for \code{lambda}
}
\details{
Computes bridge estimation
}
\examples{
set.seed(2019) 
beta <- c(3, 1.5, 0, 0, 2, 0, 0, 0)
p <- length(beta)
beta <- matrix(beta, nrow = p, ncol = 1)

n = 100
X = matrix(rnorm(n*p),n,p)
y = X\%*\%beta + rnorm(n) 

model1 <- bridge(X, y, q = 1)
print(model1)

model2 <- bridge(X, y, q = 2)
print(model2)

}
\seealso{
\code{\link{cv.bridge}}
}
\author{
Bahadir Yuzbasi, Mohammad Arashi and Fikri Akdeniz \cr Maintainer: Bahadir Yuzbasi \email{b.yzb@hotmail.com}
}
