% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{gettxoutproof}
\alias{gettxoutproof}
\title{RPC-JSON API: gettxoutproof}
\usage{
gettxoutproof(con, txids, blockhash = NULL)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{txids}{\code{charcater} a json array of txids to filter.}

\item{blockhash}{\code{integer} looks for txid in the block with this hash,
(optional, default \code{NULL}).}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Returns a hex-encoded proof that "txid" was included in a block.
}
\details{
NOTE: By default this function only works sometimes. This is when there is an
unspent output in the utxo for this transaction. To make it always work,
you need to maintain a transaction index, using the -txindex command line
option or specify the block in which the transaction is included manually
(by blockhash).
}
\references{
\url{https://bitcoin.org/en/developer-reference#gettxoutproof},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: \code{\link{decodescript}},
  \code{\link{getbestblockhash}},
  \code{\link{getblockchaininfo}},
  \code{\link{getblockcount}}, \code{\link{getblockhash}},
  \code{\link{getblockheader}}, \code{\link{getblock}},
  \code{\link{getchaintips}},
  \code{\link{getchaintxstats}},
  \code{\link{getdifficulty}},
  \code{\link{getmempoolancestors}},
  \code{\link{getmempooldescendants}},
  \code{\link{getmempoolentry}},
  \code{\link{getmempoolinfo}},
  \code{\link{getrawmempool}},
  \code{\link{gettxoutsetinfo}}, \code{\link{gettxout}},
  \code{\link{preciousblock}},
  \code{\link{pruneblockchain}}, \code{\link{verifychain}},
  \code{\link{verifytxoutproof}}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
