% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCbasis.R
\name{OCbasis}
\alias{OCbasis}
\title{Obled-Cruetin Basis Function}
\usage{
OCbasis(
  ...,
  spatialData,
  gbf,
  knots,
  dB = NULL,
  w = NULL,
  nw = NULL,
  nCore = 1L,
  longlat = TRUE
)
}
\arguments{
\item{...}{Ignored. Included only to require named inputs.}

\item{spatialData}{A SpatialPoints object, SpatialPolygons object,
or a list of said objects. The source support data.
If provided as a list, input dB must be integer or SpatialPolygons.}

\item{gbf}{A function or character object. The function to use to
calculate the radial basis functions of the expansion of the   
Obled-Creutin eigenfunction. The bi-square, wendland, and radial functions
are available through this implementation as 'bisquare', 'wendland' and
'gaussian', respectively. All others must be defined by user.  
See details for further information.}

\item{knots}{A matrix or integer. If a matrix, the knots of the
radial basis functions. If an integer, the number of knots to generate
using fields::cover.design().}

\item{dB}{NULL, integer, or a SpatialPolygons object defining the 
spatial region to be sampled when using Monte Carlo estimates.
If spatialData is a list of spatial objects, dB must be in an integer
specifying the element of spatialData to use as the sampling region
or a SpatialPolygons object.}

\item{w}{A numeric object. The scaling factor for radial basis functions. 
See details for further information.}

\item{nw}{An integer object or NULL. The number of MC replicates to 
generate for estimating the O-C eigenfunctions. If <=0 or NULL, 
spatialData must be or include SpatialPoints data.}

\item{nCore}{An integer object or NULL. The number of cores if parallel 
methods are to be used in the Monte Carlo step.}

\item{longlat}{A logical object. TRUE if spatialData is 
longitude/latitude data.}
}
\value{
A list containing:
 \item{basis}{The \{nSpatial x r\} radial basis function.}
 \item{OCnorm}{The \{r x r\} Obled Cruetin weighting matrix.}
 \item{knots}{The \{nKnots x 2\} matrix of knots.}
 \item{w}{The scaling factor used in basis.}
}
\description{
Performs a reweighting of radial basis functions ensuring orthonormality.
}
\details{
Input 'gbf' allows users to specify a radial basis function beyond
the internally implemented bi-square, wendland, and gaussian functions. 
If user provides
a function, the function must use the following formal arguments: 
\itemize{
\item crd - the coordinates at which the basis functions are to be evaluated; 
\item knots - the knots of the basis functions; 
\item w - the scaling factor for the basis function; and
\item ... - an ellipsis to avoid argument errors. 
}
The function must return a matrix of dimension 
\{nrow(crd) x nrow(knots)\}.

For completeness, the bi-square functions implemented in the package
are of the form
\deqn{\Psi_{j}(s) =
\{1 - (||s - c_j||/w)^2\}^2 \mathrm{I}( ||s-c_j|| \leq w ).}
Note that input 'w' is equivalent to \eqn{w} in the expression above.
In addition, if a user were to define an equivalent function 
inputs \eqn{s \equiv} 'crd' and \eqn{c_j \equiv} 'knots'.

The Wendland basis functions defined as
\deqn{ \Psi_{j}(s) =
 \{ 1 - d_{j}(s)\}^6 \{35 d_{j}(s)^2 + 18 d_j(s) + 3\}/3 \mathrm{I}( 0 \leq d_{j} \leq 1  ),}
where 
\deqn{ d_{j}(s) = ||s - c_j||/w.}

The Gaussian radial basis functions defined as
\deqn{ \Psi_{j}(s) =
 \exp\{- \frac{1}{2} (||s - c_j||/w)^2\}.}
}
\examples{

# create 5x5 square 

poly <- raster::rasterToPolygons(raster::raster(nrows = 5, ncols = 5,
                                                xmn = -1.25, xmx = 1.25,
                                                ymn = -1.25, ymx = 1.25,
                                                res = 0.5,
                                                crs = "+proj=longlat +datum=WGS84"))

df <- data.frame("x" = stats::rnorm(n = 25))

dt <- sp::SpatialPolygonsDataFrame(poly, df)

knots <- expand.grid(c(-0.75,0.0,0.75),c(-0.75,0.0,0.75))

OCbasis(spatialData = dt,
        gbf = 'bisquare',
        knots = knots,
        nw = 200L,
        nCore = 1L)

OCbasis(spatialData = dt,
        gbf = 'gaussian',
        knots = knots,
        nw = 200L,
        nCore = 1L)

}
