% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_sky_pixels_nonnull.R
\name{find_sky_pixels_nonnull}
\alias{find_sky_pixels_nonnull}
\title{Find sky pixels following the non-null criteria}
\usage{
find_sky_pixels_nonnull(r, sky, g, slope = 0.5)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically,
the blue channel extracted from a canopy photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{sky}{An object of class \linkS4class{SpatRaster} produced with
\code{\link{fit_coneshaped_model}}, \code{\link{fit_trend_surface}},
\code{\link{fit_cie_sky_model}}, or \code{\link{ootb_sky_reconstruction}}.}

\item{g}{\linkS4class{SpatRaster} built with
\code{\link{sky_grid_segmentation}} or \code{\link{chessboard}}.}

\item{slope}{Numeric vector of length one. See section Details in
\code{\link{thr_image}}.}
}
\value{
An object of class \linkS4class{SpatRaster} with values \code{0} and
  \code{1}.
}
\description{
Find sky pixels using the increase in the number of cells having no sky
pixels (the so-called null cells) as stopping criteria.
}
\details{
The arguments \code{sky} and \code{slope} are passed to
\code{\link{thr_image}}, which output is in turn passed to
\code{\link{apply_thr}} along with \code{r}. As a result, \code{r} is
binarized and used along with \code{g} to compute the number of null cells.
The process is repeated but increasing \code{slope} in steps of 0.05 as long
as the number of null cells remains constant.
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
caim <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
r <- gbc(caim$Blue)
bin <- find_sky_pixels(r, z, a)
g <- sky_grid_segmentation(z, a, 10)
sky_points <- extract_sky_points(r, bin, g)
sky_points <- extract_rl(r, z, a, sky_points, NULL)
model <- fit_coneshaped_model(sky_points$sky_points)
sky_cs <- model$fun(z, a)
g[mask_hs(z, 0, 10) | mask_hs(z, 70, 90)] <- NA
bin <- find_sky_pixels_nonnull(r, sky_cs, g)
plot(bin)
}
}
\seealso{
Other Binarization Functions: 
\code{\link{apply_thr}()},
\code{\link{find_sky_pixels}()},
\code{\link{obia}()},
\code{\link{ootb_mblt}()},
\code{\link{ootb_obia}()},
\code{\link{regional_thresholding}()},
\code{\link{thr_image}()},
\code{\link{thr_isodata}()}
}
\concept{Binarization Functions}
