% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ootb_obia.R
\name{ootb_obia}
\alias{ootb_obia}
\title{Out-of-the-box object-based image analysis of canopy photographs}
\usage{
ootb_obia(caim, z = NULL, a = NULL, m = NULL, sky_blue = NULL, gamma = 2.2)
}
\arguments{
\item{caim}{\linkS4class{SpatRaster}. The return of a call to
\code{\link{read_caim}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{m}{\linkS4class{SpatRaster}. Default (\code{NULL}) is the equivalent to
enter \code{!is.na(z)} for hemispherical photography, or enter
\code{!is.na(caim$Red)} for restricted view photography.}

\item{sky_blue}{\linkS4class{color}. Is the \code{target_color} argument to
be passed to \code{\link{membership_to_color}}. Default (\code{NULL}) is
the equivalent to enter \code{sRGB(0.1, 0.4, 0.8)}--the HEX color code is
#1A66CC, it can be entered into a search engine (such as Mozilla Firefox)
to see a color swatch.}

\item{gamma}{Numeric vector of length one. This is for applying a gamma back
correction to the lightness information (see Details and argument
\code{w_red}).}
}
\value{
An object of class \linkS4class{SpatRaster} with values \code{0} and
  \code{1}.
}
\description{
Out-of-the-box version of methods first presented in
\insertCite{Diaz2015;textual}{rcaiman}.
}
\details{
This function is a hard-coded version of a pipeline that combines these main
functions \code{\link{mask_sunlit_canopy}}, \code{\link{enhance_caim}},
\code{\link{polar_qtree}}/\code{\link{qtree}}, and \code{\link{obia}}. The
code can be easily inspected by calling \code{ootb_obia} --no parenthesis.
Advanced users can use that code as a template.

Pixels from the synthetic layer returned by \code{\link{obia}} that lay
between \code{0} and \code{1} are assigned to the class \emph{plant} only if
they are:

\itemize{

\item \code{0} after \code{\link{defuzzify}} with a sky grid segmentation of
\code{10} degrees.

\item \code{0} after \code{\link{apply_thr}} with a threshold computed with
\code{\link{thr_isodata}}.

\item Not exclusively surrounded by sky pixels.

}

Default values of \code{z} and \code{a} allows the processing of restricted
view photographs.

If you use this function in your research, please cite
\insertCite{Diaz2015;textual}{rcaiman} or \insertCite{Diaz2023}{rcaiman} in
addition to this package.
}
\examples{
\dontrun{
#circular hemispherical photo
path <- system.file("external/b4_2_5724.jpg", package = "rcaiman")
caim <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2) \%>\%
  normalize()
z <- zenith_image(1490, lens("Nikon_FCE9"))
a <- azimuth_image(z)

bin <- ootb_obia(caim, z, a)
plot(bin)

## to compare
blue <- gbc(caim$Blue*255)
plot(apply_thr(blue, thr_isodata(blue[!is.na(z)])))
plot(blue, col = seq(0,1,1/255) \%>\% grey())

#hemispherical photo from a smartphone
path <- system.file("external/APC_0581.jpg", package = "rcaiman")
caim <- read_caim(path) \%>\% normalize()
z <- zenith_image(2132/2, lens("Olloclip"))
a <- azimuth_image(z)
zenith_colrow <- c(1063, 771)/2
caim <- expand_noncircular(caim, z, zenith_colrow) \%>\% normalize()
m <- !is.na(caim$Red) & !is.na(z)
caim[!m] <- 0

bin <- ootb_obia(caim, z, a)
plot(bin)

## to compare
blue <- gbc(caim$Blue*255)
plot(apply_thr(blue, thr_isodata(blue[m])))
plot(blue, col = seq(0,1,1/255) \%>\% grey())

#restricted view canopy photo
path <- system.file("external/APC_0020.jpg", package = "rcaiman")
caim <- read_caim(path) \%>\% normalize()

bin <- ootb_obia(caim)
plot(bin)

## to compare
blue <- gbc(caim$Blue*255)
plot(apply_thr(blue, thr_isodata(blue[])))
plot(blue, col = seq(0,1,1/255) \%>\% grey())
}
}
\seealso{
Other Binarization Functions: 
\code{\link{apply_thr}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{obia}()},
\code{\link{ootb_mblt}()},
\code{\link{regional_thresholding}()},
\code{\link{thr_image}()},
\code{\link{thr_isodata}()}
}
\concept{Binarization Functions}
