% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize data}
\usage{
normalize(r, mn = NULL, mx = NULL, force_range = FALSE)
}
\arguments{
\item{r}{\linkS4class{SpatRaster} or numeric vector.}

\item{mn}{Numeric vector of length one. Minimum expected value. Default is
equivalent to enter the minimum value from \code{r}.}

\item{mx}{Numeric vector of length one. Maximum expected value. Default is
equivalent to enter the maximum value from \code{r}.}

\item{force_range}{Logical vector of length one. If it is \code{TRUE}, the
range is forced to be between \code{0} and \code{1} by flattening values
found below and above those limits.}
}
\value{
An object from the same class as \code{r} with values from \code{r}
linearly rescaled to make \code{mn} equal to zero and \code{mx} equal to
one. Therefore, if \code{mn} and \code{mx} do not match the actual minimum
and maximum from \code{r}, then the output will not cover the 0-to-1 range
and may be outside that range if \code{force_range} is set to \code{FALSE}.
}
\description{
Normalize numeric and raster data.
}
\details{
Normalize data laying between \code{mn} and \code{mx} to the range \code{0}
to \code{1}. Data greater than \code{mx} get values greater than \code{1} in
a proportional fashion. Conversely, data less than \code{mn} get values less
than \code{0}.This function can be used for linear stretching of the
histogram.
}
\examples{
normalize(read_caim())
}
\seealso{
Other Pre-processing Functions: 
\code{\link{enhance_caim}()},
\code{\link{gbc}()},
\code{\link{local_fuzzy_thresholding}()},
\code{\link{membership_to_color}()}
}
\concept{Pre-processing Functions}
