/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.draw;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.applications.jchempaint.JChemPaintEditorPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.layout.StructureDiagramGenerator;

public class Get2DStructureFromJCP {
    private static IChemModel chemModel;

    public Get2DStructureFromJCP() {
    }

    public Get2DStructureFromJCP(IAtomContainer molecule) {
        IMolecule localMolecule = null;
        try {
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setMolecule((IMolecule)molecule);
            sdg.generateCoordinates();
            localMolecule = sdg.getMolecule();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        IMoleculeSet som = DefaultChemObjectBuilder.getInstance().newMoleculeSet();
        som.addMolecule(localMolecule);
        chemModel = DefaultChemObjectBuilder.getInstance().newChemModel();
        chemModel.setSetOfMolecules(som);
    }

    public void showWindow() {
        JFrame frame = new JFrame();
        JDialog dlg = new JDialog((Frame)frame, true);
        dlg.setTitle("Molecule Editor");
        dlg.setDefaultCloseOperation(0);
        dlg.addWindowListener(new MyAppCloser());
        JChemPaintEditorPanel editPanel = new JChemPaintEditorPanel();
        JChemPaintModel model = new JChemPaintModel();
        editPanel.registerModel(model);
        editPanel.setJChemPaintModel(model);
        dlg.add((Component)editPanel);
        dlg.pack();
        dlg.setVisible(true);
    }

    public IChemModel getChemModel() {
        return chemModel;
    }

    public IAtomContainer[] getMolecules() {
        IMoleculeSet som = chemModel.getSetOfMolecules();
        if (som == null) {
            return null;
        }
        return som.getMolecules();
    }

    public static void main(String[] args) {
        Get2DStructureFromJCP e = new Get2DStructureFromJCP();
        e.showWindow();
        System.exit(0);
    }

    private static final class MyAppCloser
    extends WindowAdapter {
        private MyAppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            JDialog dlg = (JDialog)e.getSource();
            JChemPaintEditorPanel editPanel = (JChemPaintEditorPanel)dlg.getContentPane().getComponent(0);
            chemModel = editPanel.getChemModel();
            ((JDialog)e.getSource()).setVisible(false);
            ((JDialog)e.getSource()).dispose();
        }
    }
}

