/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.ArrayUtil;

class FoldingXyzReader
extends AtomSetCollectionReader {
    private static final boolean useAutoBond = false;

    FoldingXyzReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("Folding@Home");
        try {
            StringTokenizer tokens = new StringTokenizer(this.readLine(), " \t");
            if (tokens.hasMoreTokens()) {
                int modelAtomCount = Integer.parseInt(tokens.nextToken());
                this.atomSetCollection.newAtomSet();
                if (tokens.hasMoreTokens()) {
                    this.atomSetCollection.setAtomSetName("Protein " + tokens.nextToken());
                }
                this.readAtoms(modelAtomCount);
            }
        }
        catch (Exception ex) {
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
        }
        return this.atomSetCollection;
    }

    void readAtoms(int modelAtomCount) throws Exception {
        int start;
        int i;
        int[][] bonds = new int[modelAtomCount + 1][];
        for (i = 0; i <= modelAtomCount; ++i) {
            bonds[i] = null;
        }
        for (i = 0; i <= modelAtomCount; ++i) {
            this.readLine();
            if (this.line != null && this.line.length() == 0) {
                this.readLine();
            }
            if (this.line == null || this.line.length() <= 0) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            this.parseInt(this.line);
            atom.atomName = this.parseToken(this.line, this.ichNextParse);
            if (atom.atomName != null) {
                int carCount = 1;
                if (atom.atomName.length() >= 2) {
                    char c1 = atom.atomName.charAt(0);
                    char c2 = atom.atomName.charAt(1);
                    if (Character.isUpperCase(c1) && Character.isLowerCase(c2) && Atom.isValidElementSymbol(c1, c2)) {
                        carCount = 2;
                    }
                    if (c1 == 'C' && c2 == 'L') {
                        carCount = 2;
                    }
                }
                atom.elementSymbol = atom.atomName.substring(0, carCount);
            }
            atom.x = this.parseFloat(this.line, this.ichNextParse);
            atom.y = this.parseFloat(this.line, this.ichNextParse);
            atom.z = this.parseFloat(this.line, this.ichNextParse);
            int bondCount = 0;
            bonds[i] = new int[5];
            int bondNum = Integer.MIN_VALUE;
            while ((bondNum = this.parseInt(this.line, this.ichNextParse)) > 0) {
                if (bondCount == bonds[i].length) {
                    bonds[i] = ArrayUtil.setLength(bonds[i], bondCount + 1);
                }
                bonds[i][bondCount++] = bondNum - 1;
            }
            if (bondCount >= bonds[i].length) continue;
            bonds[i] = ArrayUtil.setLength(bonds[i], bondCount);
        }
        int incorrectBonds = 0;
        for (int origin = 0; origin < bonds.length; ++origin) {
            if (bonds[origin] == null || bonds[origin].length <= 0) continue;
            boolean correct = false;
            int destination = bonds[origin][0];
            if (destination >= 0 && destination < bonds.length && bonds[destination] != null) {
                for (int j = 0; j < bonds[destination].length; ++j) {
                    if (bonds[destination][j] != origin) continue;
                    correct = true;
                }
            }
            if (correct) continue;
            ++incorrectBonds;
        }
        for (int origin = start = incorrectBonds * 5 > bonds.length ? 1 : 0; origin < bonds.length; ++origin) {
            if (bonds[origin] == null) continue;
            for (int i2 = 0; i2 < bonds[origin].length; ++i2) {
                boolean correct = false;
                int destination = bonds[origin][i2];
                if (destination >= 0 && destination < bonds.length && bonds[destination] != null) {
                    for (int j = start; j < bonds[destination].length; ++j) {
                        if (bonds[destination][j] != origin) continue;
                        correct = true;
                    }
                }
                if (!correct || destination <= origin) continue;
                this.atomSetCollection.addNewBond(origin, destination);
            }
        }
    }
}

