/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import org.jmol.bspt.Bspt;
import org.jmol.bspt.SphereIterator;
import org.jmol.bspt.Tuple;

public final class Bspf {
    int dimMax;
    Bspt[] bspts;
    SphereIterator[] sphereIterators;

    public Bspf(int dimMax) {
        this.dimMax = dimMax;
        this.bspts = new Bspt[0];
        this.sphereIterators = new SphereIterator[0];
    }

    public int getBsptCount() {
        return this.bspts.length;
    }

    public void addTuple(int bsptIndex, Tuple tuple) {
        Bspt bspt;
        if (bsptIndex >= this.bspts.length) {
            Bspt[] t = new Bspt[bsptIndex + 1];
            System.arraycopy(this.bspts, 0, t, 0, this.bspts.length);
            this.bspts = t;
        }
        if ((bspt = this.bspts[bsptIndex]) == null) {
            bspt = this.bspts[bsptIndex] = new Bspt(this.dimMax);
        }
        bspt.addTuple(tuple);
    }

    public void stats() {
        for (int i = 0; i < this.bspts.length; ++i) {
            this.bspts[i].stats();
        }
    }

    public SphereIterator getSphereIterator(int bsptIndex) {
        if (bsptIndex >= this.sphereIterators.length) {
            SphereIterator[] t = new SphereIterator[bsptIndex + 1];
            System.arraycopy(this.sphereIterators, 0, t, 0, this.sphereIterators.length);
            this.sphereIterators = t;
        }
        if (this.sphereIterators[bsptIndex] == null && this.bspts[bsptIndex] != null) {
            this.sphereIterators[bsptIndex] = this.bspts[bsptIndex].allocateSphereIterator();
        }
        return this.sphereIterators[bsptIndex];
    }
}

