/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;

public class UnitCell {
    static final float toRadians = (float)Math.PI / 180;
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    public static final int INFO_A = 0;
    public static final int INFO_B = 1;
    public static final int INFO_C = 2;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_BETA = 4;
    public static final int INFO_GAMMA = 5;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float[] notionalUnitcell;
    Matrix4f matrixNotional;
    Matrix4f matrixCartesianToFractional;
    Matrix4f matrixFractionalToCartesian;
    Point3f[] vertices;
    Point3f cartesianOffset = new Point3f();
    Point3f fractionalOffset = new Point3f();

    public UnitCell(float[] notionalUnitcell) {
        this.setUnitCell(notionalUnitcell);
    }

    public final void toCartesian(Point3f pt) {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixFractionalToCartesian.transform(pt);
    }

    public final void toFractional(Point3f pt) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(pt);
    }

    public void setOffset(Point3f pt) {
        this.fractionalOffset.set(pt);
        this.cartesianOffset.set(pt);
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
    }

    public void setOffset(int nnn) {
        Point3f cell = new Point3f();
        cell.x = nnn / 100 - 5;
        cell.y = nnn % 100 / 10 - 5;
        cell.z = nnn % 10 - 5;
        this.setOffset(cell);
    }

    public final String dumpInfo(boolean isFull) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (isFull ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    public Point3f[] getVertices() {
        return this.vertices;
    }

    public Point3f getCartesianOffset() {
        return this.cartesianOffset;
    }

    public Point3f getFractionalOffset() {
        return this.fractionalOffset;
    }

    public float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    public float getInfo(int infoType) {
        switch (infoType) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
        }
        return Float.NaN;
    }

    private void setUnitCell(float[] notionalUnitcell) {
        if (notionalUnitcell == null || notionalUnitcell[0] == 0.0f) {
            return;
        }
        this.notionalUnitcell = notionalUnitcell;
        this.a = notionalUnitcell[0];
        this.b = notionalUnitcell[1];
        this.c = notionalUnitcell[2];
        this.alpha = notionalUnitcell[3];
        this.beta = notionalUnitcell[4];
        this.gamma = notionalUnitcell[5];
        this.calcNotionalMatrix();
        this.constructFractionalMatrices();
        this.calcUnitcellVertices();
    }

    private final void calcNotionalMatrix() {
        this.matrixNotional = new Matrix4f();
        float cosAlpha = (float)Math.cos((float)Math.PI / 180 * this.alpha);
        float cosBeta = (float)Math.cos((float)Math.PI / 180 * this.beta);
        float cosGamma = (float)Math.cos((float)Math.PI / 180 * this.gamma);
        float sinGamma = (float)Math.sin((float)Math.PI / 180 * this.gamma);
        this.matrixNotional.setColumn(0, this.a, 0.0f, 0.0f, 0.0f);
        this.matrixNotional.setColumn(1, this.b * cosGamma, this.b * sinGamma, 0.0f, 0.0f);
        float V = this.a * this.b * this.c * (float)Math.sqrt(1.0 - (double)(cosAlpha * cosAlpha) - (double)(cosBeta * cosBeta) - (double)(cosGamma * cosGamma) + 2.0 * (double)cosAlpha * (double)cosBeta * (double)cosGamma);
        this.matrixNotional.setColumn(2, this.c * cosBeta, this.c * (cosAlpha - cosBeta * cosGamma) / sinGamma, V / (this.a * this.b * sinGamma), 0.0f);
        this.matrixNotional.setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    private final void constructFractionalMatrices() {
        if (this.notionalUnitcell.length > 6 && !Float.isNaN(this.notionalUnitcell[6])) {
            float[] scaleMatrix = new float[16];
            for (int i = 0; i < 16; ++i) {
                scaleMatrix[i] = this.notionalUnitcell[6 + i];
            }
            this.matrixCartesianToFractional = new Matrix4f(scaleMatrix);
            this.matrixFractionalToCartesian = new Matrix4f();
            this.matrixFractionalToCartesian.invert(this.matrixCartesianToFractional);
        } else {
            this.matrixFractionalToCartesian = this.matrixNotional;
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        }
    }

    private final void calcUnitcellVertices() {
        this.vertices = new Point3f[8];
        int i = 8;
        while (--i >= 0) {
            this.vertices[i] = new Point3f();
            this.matrixFractionalToCartesian.transform(unitCubePoints[i], this.vertices[i]);
        }
    }
}

