/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.Polymer;

class NucleicPolymer
extends Polymer {
    NucleicPolymer(Monomer[] monomers) {
        super(monomers);
    }

    Atom getNucleicPhosphorusAtom(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtom();
    }

    boolean hasWingPoints() {
        return true;
    }

    void calcHydrogenBonds(BitSet bsA, BitSet bsB) {
        int i = this.model.getPolymerCount();
        while (--i >= 0) {
            Polymer otherPolymer = this.model.getPolymer(i);
            if (otherPolymer == this || otherPolymer == null || !(otherPolymer instanceof NucleicPolymer)) continue;
            this.lookForHbonds((NucleicPolymer)otherPolymer, bsA, bsB);
        }
    }

    void lookForHbonds(NucleicPolymer other, BitSet bsA, BitSet bsB) {
        int i = this.monomerCount;
        while (--i >= 0) {
            NucleicMonomer myNucleotide = (NucleicMonomer)this.monomers[i];
            if (!myNucleotide.isPurine()) continue;
            Atom myN1 = myNucleotide.getN1();
            Atom bestN3 = null;
            float minDist2 = 25.0f;
            NucleicMonomer bestNucleotide = null;
            int j = other.monomerCount;
            while (--j >= 0) {
                Atom otherN3;
                float dist2;
                NucleicMonomer otherNucleotide = (NucleicMonomer)other.monomers[j];
                if (!otherNucleotide.isPyrimidine() || !((dist2 = myN1.distanceSquared(otherN3 = otherNucleotide.getN3())) < minDist2)) continue;
                bestNucleotide = otherNucleotide;
                bestN3 = otherN3;
                minDist2 = dist2;
            }
            if (bestN3 == null) continue;
            this.createHydrogenBond(myN1, bestN3, bsA, bsB);
            if (myNucleotide.isGuanine()) {
                this.createHydrogenBond(myNucleotide.getN2(), bestNucleotide.getO2(), bsA, bsB);
                this.createHydrogenBond(myNucleotide.getO6(), bestNucleotide.getN4(), bsA, bsB);
                continue;
            }
            this.createHydrogenBond(myNucleotide.getN6(), bestNucleotide.getO4(), bsA, bsB);
        }
    }

    void createHydrogenBond(Atom atom1, Atom atom2, BitSet bsA, BitSet bsB) {
        if (atom1 != null && atom2 != null) {
            Frame frame = this.model.mmset.frame;
            frame.addHydrogenBond(atom1, atom2, (short)512, bsA, bsB);
        }
    }
}

