/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.WebDialog;

public class WebLinkAction
extends JCPAction {
    private static final long serialVersionUID = -5055722920851824045L;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"Opening a webpage for: ", (Object)this.type);
        ChemModel model = null;
        try {
            model = (ChemModel)this.getSource(event);
        }
        catch (ClassCastException exception) {
            logger.error((Object)"Method is normally called on ChemModel");
            logger.debug((Object)exception);
            JOptionPane.showMessageDialog(this.jcpPanel, "Cannot display webinfo entry.");
            return;
        }
        WebDialog dialog = null;
        JFrame frame = new JFrame();
        URL url = null;
        try {
            String uri = "";
            if (this.type.equals("pdb")) {
                String pdbCode = (String)model.getProperty((Object)"org.openscience.cdk.io.MACiE.PDBCode");
                uri = "http://www.rcsb.org/pdb/cgi/explore.cgi?pdbId=" + pdbCode;
            } else if (this.type.equals("medline")) {
                String medlineCode = (String)model.getProperty((Object)"org.openscience.cdk.io.MACiE.MedlineID");
                uri = "http://www.ncbi.nlm.nih.gov/entrez/queryd.fcgi?cmd=Retrieve&db=PubMed&dopt=Abstract&list_uids=" + medlineCode;
            }
            url = new URL(uri);
        }
        catch (MalformedURLException exception) {
            logger.error((Object)"Incorrect URL");
            return;
        }
        dialog = new WebDialog(frame, url);
        dialog.setVisible(true);
    }
}

