/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import javax.swing.JPanel;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.Renderer2D;
import org.openscience.cdk.renderer.Renderer2DModel;

public class Render2DPanel
extends JPanel {
    IAtomContainer mol;
    boolean withHydrogen = true;
    Renderer2DModel r2dm;
    Renderer2D renderer;

    public Render2DPanel() {
    }

    public Render2DPanel(IAtomContainer mol, int x, int y, boolean withHydrogen) {
        this.r2dm = new Renderer2DModel();
        this.renderer = new Renderer2D(this.r2dm);
        Dimension screenSize = new Dimension(x, y);
        this.setPreferredSize(screenSize);
        this.r2dm.setBackgroundDimension(screenSize);
        this.setBackground(this.r2dm.getBackColor());
        this.mol = mol;
        this.withHydrogen = withHydrogen;
        try {
            this.r2dm.setDrawNumbers(false);
            this.r2dm.setUseAntiAliasing(true);
            this.r2dm.setColorAtomsByType(true);
            this.r2dm.setShowImplicitHydrogens(false);
            this.r2dm.setShowAromaticity(true);
            GeometryTools.translateAllPositive((IAtomContainer)this.mol, (HashMap)this.r2dm.getRenderingCoordinates());
            GeometryTools.scaleMolecule((IAtomContainer)this.mol, (Dimension)this.getPreferredSize(), (double)0.9, (HashMap)this.r2dm.getRenderingCoordinates());
            GeometryTools.center((IAtomContainer)this.mol, (Dimension)this.getPreferredSize(), (HashMap)this.r2dm.getRenderingCoordinates());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.renderer.paintMolecule(this.mol, (Graphics2D)g, false, true);
    }
}

