% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smiles.R
\name{parse.smiles}
\alias{parse.smiles}
\title{Parse SMILES strings into molecule objects.}
\usage{
parse.smiles(smiles, kekulise = TRUE, omit.nulls = FALSE, smiles.parser = NULL)
}
\arguments{
\item{smiles}{A single SMILES string or a vector of SMILES strings}

\item{kekulise}{If set to `FALSE` disables electron checking and
allows for parsing of incorrect SMILES. If a SMILES does not parse by default, try
setting this to `FALSE` - though the resultant molecule may not have consistent
bonding. As an example, `c4ccc2c(cc1=Nc3ncccc3(Cn12))c4` will not be parsed by default
because it is missing a nitrogen. With this argument set to `FALSE` it will parse
successfully, but this is a hack to handle an incorrect SMILES}

\item{omit.nulls}{If set to `TRUE`, omits SMILES which were parsed as `NULL`}

\item{smiles.parser}{A SMILES parser object obtained from \code{\link{get.smiles.parser}}}
}
\value{
A `list` of `jobjRef`s to their corresponding CDK `IAtomContainer` 
objects. If a SMILES string could not be parsed and `omit.nulls=TRUE` it 
is omited from the output list.
}
\description{
This function parses a vector of SMILES strings to generate a list of
`IAtomContainer` objects. Note that the resultant molecule will
not have any 2D or 3D coordinates.
Note that the molecules obtained from this method will not have any
aromaticity perception (unless aromatic symbols are encountered, in which 
case the relevant atoms are automatically set to aromatic), atom typing or 
isotopic configuration done on them. This is in contrast to the 
\code{\link{load.molecules}} method. Thus, you should
perform these steps manually on the molecules.
}
\seealso{
\code{\link{get.smiles}}, \code{\link{parse.smiles}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
