/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyadicPrefixMappingImpl
extends PrefixMappingImpl
implements PrefixMapping {
    private Polyadic poly;
    private PrefixMapping pending = new PrefixMappingImpl();

    public PolyadicPrefixMappingImpl(Polyadic p) {
        this.poly = p;
    }

    @Override
    protected boolean equals(PrefixMappingImpl other) {
        return this.equalsByMap(other);
    }

    @Override
    protected boolean sameAs(PrefixMappingImpl other) {
        return this.equalsByMap(other);
    }

    private PrefixMapping getBaseMapping() {
        Graph base = this.poly.getBaseGraph();
        return base == null ? this.pending : base.getPrefixMapping();
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.checkUnlocked();
        this.getBaseMapping().removeNsPrefix(prefix);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> other) {
        this.checkUnlocked();
        this.getBaseMapping().setNsPrefixes(other);
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        PrefixMapping bm = this.getBaseMapping();
        String s = bm.getNsPrefixURI(prefix);
        if (s == null && prefix.length() > 0) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = graphs.get(i).getPrefixMapping().getNsPrefixURI(prefix);
                if (ss == null) continue;
                return ss;
            }
        }
        return s;
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        Map<String, String> result = CollectionFactory.createHashedMap();
        List<Graph> graphs = this.poly.getSubGraphs();
        int i = graphs.size();
        while (i > 0) {
            result.putAll(graphs.get(--i).getPrefixMapping().getNsPrefixMap());
        }
        result.remove("");
        result.putAll(this.getBaseMapping().getNsPrefixMap());
        return result;
    }

    @Override
    public String getNsURIPrefix(String uri) {
        String s = this.getBaseMapping().getNsURIPrefix(uri);
        if (s == null) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = graphs.get(i).getPrefixMapping().getNsURIPrefix(uri);
                if (ss == null || ss.length() <= 0) continue;
                return ss;
            }
        }
        return s;
    }

    @Override
    public String expandPrefix(String prefixed) {
        String s = this.getBaseMapping().expandPrefix(prefixed);
        if (s.equals(prefixed)) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = graphs.get(i).getPrefixMapping().expandPrefix(prefixed);
                if (ss.equals(prefixed)) continue;
                return ss;
            }
        }
        return s;
    }

    @Override
    public String toString() {
        return "<polyadic prefix map>";
    }

    @Override
    public String shortForm(String uri) {
        String s = this.getBaseMapping().shortForm(uri);
        if (s.equals(uri)) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = graphs.get(i).getPrefixMapping().shortForm(uri);
                if (ss.equals(uri)) continue;
                return ss;
            }
        }
        return s;
    }

    @Override
    public String qnameFor(String uri) {
        String result = this.getBaseMapping().qnameFor(uri);
        if (result == null) {
            List<Graph> graphs = this.poly.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                String ss = graphs.get(i).getPrefixMapping().qnameFor(uri);
                if (ss == null) continue;
                return ss;
            }
        }
        return result;
    }
}

