/*
 * Decompiled with CFR 0.152.
 */
package signature.simple;

import junit.framework.Assert;
import org.junit.Test;
import signature.ColoredTree;
import signature.simple.SimpleGraph;
import signature.simple.SimpleGraphBuilder;
import signature.simple.SimpleGraphFactory;
import signature.simple.SimpleGraphSignature;
import signature.simple.SimpleVertexSignature;

public class SimpleGraphTest {
    public SimpleGraphSignature signatureFromString(String string) {
        SimpleGraph graph = new SimpleGraph(string);
        return new SimpleGraphSignature(graph);
    }

    @Test
    public void testChain() {
        String chain = "0:1,1:2,2:3,3:4";
        SimpleGraphSignature signature = this.signatureFromString(chain);
        String uncanonizedString = signature.toCanonicalString();
        String maxSignature = signature.getMaximalSignature();
        Assert.assertEquals((String)uncanonizedString, (String)maxSignature);
    }

    @Test
    public void testColoredTreeRoundtrip() {
        String signatureString = "[.]([.]([.,0])[.]([.,0]))";
        ColoredTree tree = SimpleVertexSignature.parse(signatureString);
        Assert.assertEquals((String)signatureString, (String)tree.toString());
        SimpleGraphBuilder builder = new SimpleGraphBuilder();
        SimpleGraph graph = builder.fromTree(tree);
        SimpleGraphSignature graphSignature = new SimpleGraphSignature(graph);
        String canonicalString = graphSignature.toCanonicalString();
        Assert.assertEquals((String)signatureString, (String)canonicalString);
    }

    @Test
    public void testVertexCount() {
    }

    @Test
    public void signatureHeightTest() {
        SimpleGraph g = SimpleGraphFactory.makeCuneane();
        SimpleGraphSignature signature = new SimpleGraphSignature(g);
        int h = 1;
        while (h < g.getVertexCount()) {
            int i = 0;
            while (i < g.getVertexCount()) {
                String sig = signature.signatureStringForVertex(i, h);
                System.out.println(String.valueOf(h) + "\t" + i + "\t" + sig);
                ++i;
            }
            ++h;
        }
    }
}

