/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class LonePairElectronChecker {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(LonePairElectronChecker.class);
    private static AtomTypeFactory factory;

    private void createAtomTypeFactory(IChemObjectBuilder builder) {
        if (factory == null) {
            factory = AtomTypeFactory.getInstance("org/openscience/cdk/dict/data/cdk-atom-types.owl", builder);
        }
    }

    public boolean isSaturated(IAtomContainer container) throws CDKException {
        return this.allSaturated(container);
    }

    public boolean allSaturated(IAtomContainer ac) throws CDKException {
        logger.debug("Are all atoms saturated?");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (this.isSaturated(ac.getAtom(f), ac)) continue;
            return false;
        }
        return true;
    }

    public boolean isSaturated(IAtom atom, IAtomContainer ac) throws CDKException {
        this.createAtomTypeFactory(ac.getBuilder());
        IAtomType atomType = factory.getAtomType(atom.getAtomTypeName());
        int lpCount = (Integer)atomType.getProperty("cdk:Lone Pair Count");
        int foundLPCount = ac.getConnectedLonePairsCount(atom);
        return foundLPCount >= lpCount;
    }

    public void saturate(IAtomContainer atomContainer) throws CDKException {
        logger.info("Saturating atomContainer by adjusting lone pair electrons...");
        boolean allSaturated = this.allSaturated(atomContainer);
        if (!allSaturated) {
            for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
                this.saturate(atomContainer.getAtom(i), atomContainer);
            }
        }
    }

    public void saturate(IAtom atom, IAtomContainer ac) throws CDKException {
        logger.info("Saturating atom by adjusting lone pair electrons...");
        IAtomType atomType = factory.getAtomType(atom.getAtomTypeName());
        int lpCount = (Integer)atomType.getProperty("cdk:Lone Pair Count");
        int missingLPs = lpCount - ac.getConnectedLonePairsCount(atom);
        for (int j = 0; j < missingLPs; ++j) {
            ILonePair lp = atom.getBuilder().newInstance(ILonePair.class, atom);
            ac.addLonePair(lp);
        }
    }
}

