/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.LargestPiSystemDescriptorTest")
public class LargestPiSystemDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] names = new String[]{"nAtomP"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#largestPiSystem", this.getClass().getName(), "$Id: eb659bf419bdddb058dfbb0388a588d72c8f2c54 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("LargestPiSystemDescriptor only expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        int i;
        boolean[] originalFlag4 = new boolean[container.getAtomCount()];
        for (int i2 = 0; i2 < originalFlag4.length; ++i2) {
            originalFlag4[i2] = container.getAtom(i2).getFlag(4);
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
                CDKHueckelAromaticityDetector.detectAromaticity(container);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        int largestPiSystemAtomsCount = 0;
        for (i = 0; i < container.getAtomCount(); ++i) {
            container.getAtom(i).setFlag(4, false);
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            if (!((container.getMaximumBondOrder(container.getAtom(i)) != IBond.Order.SINGLE || Math.abs(container.getAtom(i).getFormalCharge()) >= 1 || container.getAtom(i).getFlag(5) || container.getAtom(i).getSymbol().equals("N") || container.getAtom(i).getSymbol().equals("O")) & !container.getAtom(i).getFlag(4))) continue;
            ArrayList<IAtom> startSphere = new ArrayList<IAtom>();
            ArrayList<IAtom> path = new ArrayList<IAtom>();
            startSphere.add(container.getAtom(i));
            try {
                this.breadthFirstSearch(container, startSphere, path);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
            if (path.size() <= largestPiSystemAtomsCount) continue;
            largestPiSystemAtomsCount = path.size();
        }
        for (i = 0; i < originalFlag4.length; ++i) {
            container.getAtom(i).setFlag(4, originalFlag4[i]);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(largestPiSystemAtomsCount), this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    private void breadthFirstSearch(IAtomContainer container, List<IAtom> sphere, List<IAtom> path) throws CDKException {
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        for (IAtom atom : sphere) {
            List<IBond> bonds = container.getConnectedBondsList(atom);
            for (IBond bond : bonds) {
                IAtom nextAtom = bond.getConnectedAtom(atom);
                if ((container.getMaximumBondOrder(nextAtom) != IBond.Order.SINGLE || Math.abs(nextAtom.getFormalCharge()) >= 1 || nextAtom.getFlag(5) || nextAtom.getSymbol().equals("N") || nextAtom.getSymbol().equals("O")) & !nextAtom.getFlag(4)) {
                    path.add(nextAtom);
                    nextAtom.setFlag(4, true);
                    if (container.getConnectedBondsCount(nextAtom) <= 1) continue;
                    newSphere.add(nextAtom);
                    continue;
                }
                nextAtom.setFlag(4, true);
            }
        }
        if (newSphere.size() > 0) {
            this.breadthFirstSearch(container, newSphere, path);
        }
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        if ("checkAromaticity".equals(name)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

