/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.formula.IsotopeContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.formula.IsotopePatternTest")
public class IsotopePattern {
    private List<IsotopeContainer> isotopeCList = new ArrayList<IsotopeContainer>();
    private int monoIsotopePosition;
    private double chargI = 0.0;

    @TestMethod(value="testSetMonoIsotope_IsotopeContainer")
    public void setMonoIsotope(IsotopeContainer isoContainer) {
        this.isotopeCList.add(isoContainer);
        this.monoIsotopePosition = this.isotopeCList.indexOf(isoContainer);
    }

    @TestMethod(value="testAddIsotope_IsotopeContainer")
    public void addIsotope(IsotopeContainer isoContainer) {
        this.isotopeCList.add(isoContainer);
    }

    @TestMethod(value="testGetMonoIsotope")
    public IsotopeContainer getMonoIsotope() {
        return this.isotopeCList.get(this.monoIsotopePosition);
    }

    @TestMethod(value="testGetIsotopes")
    public List<IsotopeContainer> getIsotopes() {
        return this.isotopeCList;
    }

    @TestMethod(value="testGetIsotope_int")
    public IsotopeContainer getIsotope(int position) {
        return this.isotopeCList.get(position);
    }

    @TestMethod(value="testGetNumberOfIsotopes")
    public int getNumberOfIsotopes() {
        return this.isotopeCList.size();
    }

    @TestMethod(value="testSetCharge_double")
    public void setCharge(double charge) {
        this.chargI = charge;
    }

    @TestMethod(value="testGetCharge")
    public double getCharge() {
        return this.chargI;
    }

    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        IsotopePattern isoClone = new IsotopePattern();
        IsotopeContainer isoHighest = this.getMonoIsotope();
        for (IsotopeContainer isoContainer : this.isotopeCList) {
            if (isoHighest.equals(isoContainer)) {
                isoClone.setMonoIsotope((IsotopeContainer)isoContainer.clone());
                continue;
            }
            isoClone.addIsotope((IsotopeContainer)isoContainer.clone());
        }
        isoClone.setCharge(this.getCharge());
        return isoClone;
    }
}

