/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator.event;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.ReaderEvent;
import org.openscience.cdk.io.iterator.event.IEventChemObjectReader;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.io.setting.IOSetting;

public abstract class DefaultEventChemObjectReader
implements IEventChemObjectReader {
    private ReaderEvent frameReadEvent = null;
    private List<IChemObjectIOListener> listenerList = new ArrayList<IChemObjectIOListener>();

    public void addChemObjectIOListener(IChemObjectIOListener listener) {
        this.listenerList.add(listener);
    }

    public void removeChemObjectIOListener(IChemObjectIOListener listener) {
        this.listenerList.remove(listener);
    }

    public boolean accepts(IChemObject object) {
        return this.accepts(object.getClass());
    }

    public boolean accepts(Class objectClass) {
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void fireFrameRead() {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            IReaderListener listener = (IReaderListener)this.listenerList.get(i);
            if (this.frameReadEvent == null) {
                this.frameReadEvent = new ReaderEvent(this);
            }
            listener.frameRead(this.frameReadEvent);
        }
    }

    protected void fireIOSettingQuestion(IOSetting setting) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            IChemObjectIOListener listener = this.listenerList.get(i);
            listener.processIOSettingQuestion(setting);
        }
    }

    public IOSetting[] getIOSettings() {
        return new IOSetting[0];
    }
}

