/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.reaction.type.RearrangementLonePairReactionTest")
public class RearrangementLonePairReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RearrangementLonePairReaction.class);

    @TestMethod(value="testGetSpecification")
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#RearrangementLonePair", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testInitiate_IMoleculeSet_IMoleculeSet")
    public IReactionSet initiate(IMoleculeSet reactants, IMoleculeSet agents) throws CDKException {
        logger.debug("initiate reaction: RearrangementLonePairReaction");
        if (reactants.getMoleculeCount() != 1) {
            throw new CDKException("RearrangementLonePairReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("RearrangementLonePairReaction don't expects agents");
        }
        IReactionSet setOfReactions = DefaultChemObjectBuilder.getInstance().newInstance(IReactionSet.class, new Object[0]);
        IMolecule reactant = reactants.getMolecule(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getFlag(10) || (atomi.getFormalCharge() == CDKConstants.UNSET ? 0 : atomi.getFormalCharge()) != 0 || reactant.getConnectedLonePairsCount(atomi) <= 0) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                IAtom atomj;
                if (!bondi.getFlag(10) || bondi.getOrder() != IBond.Order.SINGLE || !(atomj = bondi.getConnectedAtom(atomi)).getFlag(10) || (atomj.getFormalCharge() == CDKConstants.UNSET ? 0 : atomj.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atomj) != 0) continue;
                for (IBond bondj : reactant.getConnectedBondsList(atomj)) {
                    IAtom atomk;
                    if (bondj.equals(bondi) || !bondj.getFlag(10) || bondj.getOrder() != IBond.Order.DOUBLE || !(atomk = bondj.getConnectedAtom(atomj)).getFlag(10) || reactant.getConnectedSingleElectronsCount(atomk) != 0 || (atomk.getFormalCharge() == CDKConstants.UNSET ? 0 : atomk.getFormalCharge()) < 0) continue;
                    ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                    atomList.add(atomi);
                    atomList.add(atomj);
                    atomList.add(atomk);
                    ArrayList<IBond> bondList = new ArrayList<IBond>();
                    bondList.add(bondi);
                    bondList.add(bondj);
                    IMoleculeSet moleculeSet = reactant.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                    moleculeSet.addMolecule(reactant);
                    IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                    if (reaction == null) continue;
                    setOfReactions.addReaction(reaction);
                }
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IMolecule reactant) throws CDKException {
        for (IAtom atomi : reactant.atoms()) {
            if ((atomi.getFormalCharge() == CDKConstants.UNSET ? 0 : atomi.getFormalCharge()) != 0 || reactant.getConnectedLonePairsCount(atomi) <= 0) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                IAtom atomj;
                if (bondi.getOrder() != IBond.Order.SINGLE || ((atomj = bondi.getConnectedAtom(atomi)).getFormalCharge() == CDKConstants.UNSET ? 0 : atomj.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atomj) != 0) continue;
                for (IBond bondj : reactant.getConnectedBondsList(atomj)) {
                    IAtom atomk;
                    if (bondj.equals(bondi) || bondj.getOrder() != IBond.Order.DOUBLE || reactant.getConnectedSingleElectronsCount(atomk = bondj.getConnectedAtom(atomj)) != 0 || (atomk.getFormalCharge() == CDKConstants.UNSET ? 0 : atomk.getFormalCharge()) < 0) continue;
                    atomi.setFlag(10, true);
                    atomj.setFlag(10, true);
                    atomk.setFlag(10, true);
                    bondi.setFlag(10, true);
                    bondj.setFlag(10, true);
                }
            }
        }
    }
}

