/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.tools.manipulator.ReactionManipulatorTest")
public class ReactionManipulator {
    @TestMethod(value="testGetAtomCount_IReaction")
    public static int getAtomCount(IReaction reaction) {
        int count = 0;
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getMolecule(i).getAtomCount();
        }
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getMolecule(i).getAtomCount();
        }
        return count;
    }

    @TestMethod(value="testGetBondCount_IReaction")
    public static int getBondCount(IReaction reaction) {
        int count = 0;
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            count += reactants.getMolecule(i).getBondCount();
        }
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            count += products.getMolecule(i).getBondCount();
        }
        return count;
    }

    @TestMethod(value="testRemoveAtomAndConnectedElectronContainers_IReaction_IAtom")
    public static void removeAtomAndConnectedElectronContainers(IReaction reaction, IAtom atom) {
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IMolecule mol = reactants.getMolecule(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IMolecule mol = products.getMolecule(i);
            if (!mol.contains(atom)) continue;
            mol.removeAtomAndConnectedElectronContainers(atom);
        }
    }

    @TestMethod(value="testRemoveElectronContainer_IReaction_IElectronContainer")
    public static void removeElectronContainer(IReaction reaction, IElectronContainer electrons) {
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IMolecule mol = reactants.getMolecule(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IMolecule mol = products.getMolecule(i);
            if (!mol.contains(electrons)) continue;
            mol.removeElectronContainer(electrons);
        }
    }

    @TestMethod(value="testGetAllMolecules_IReaction")
    public static IMoleculeSet getAllMolecules(IReaction reaction) {
        IMoleculeSet moleculeSet = reaction.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        moleculeSet.add(ReactionManipulator.getAllReactants(reaction));
        moleculeSet.add(ReactionManipulator.getAllProducts(reaction));
        return moleculeSet;
    }

    @TestMethod(value="testGetAllProducts_IReaction")
    public static IMoleculeSet getAllProducts(IReaction reaction) {
        IMoleculeSet moleculeSet = reaction.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            moleculeSet.addMolecule(products.getMolecule(i));
        }
        return moleculeSet;
    }

    @TestMethod(value="testGetAllReactants_IReaction")
    public static IMoleculeSet getAllReactants(IReaction reaction) {
        IMoleculeSet moleculeSet = reaction.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            moleculeSet.addMolecule(reactants.getMolecule(i));
        }
        return moleculeSet;
    }

    @TestMethod(value="testReverse_IReaction")
    public static IReaction reverse(IReaction reaction) {
        IReaction reversedReaction = reaction.getBuilder().newInstance(IReaction.class, new Object[0]);
        if (reaction.getDirection() == IReaction.Direction.BIDIRECTIONAL) {
            reversedReaction.setDirection(IReaction.Direction.BIDIRECTIONAL);
        } else if (reaction.getDirection() == IReaction.Direction.FORWARD) {
            reversedReaction.setDirection(IReaction.Direction.BACKWARD);
        } else if (reaction.getDirection() == IReaction.Direction.BACKWARD) {
            reversedReaction.setDirection(IReaction.Direction.FORWARD);
        }
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getReactantCoefficient(reactants.getMolecule(i));
            reversedReaction.addProduct(reactants.getMolecule(i), coefficient);
        }
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            double coefficient = reaction.getProductCoefficient(products.getMolecule(i));
            reversedReaction.addReactant(products.getMolecule(i), coefficient);
        }
        return reversedReaction;
    }

    @TestMethod(value="testGetAllAtomContainers_IReaction")
    public static List<IAtomContainer> getAllAtomContainers(IReaction reaction) {
        return MoleculeSetManipulator.getAllAtomContainers(ReactionManipulator.getAllMolecules(reaction));
    }

    @TestMethod(value="testGetAllIDs_IReaction")
    public static List<String> getAllIDs(IReaction reaction) {
        ArrayList<String> idList = new ArrayList<String>();
        if (reaction.getID() != null) {
            idList.add(reaction.getID());
        }
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            IMolecule mol = reactants.getMolecule(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            IMolecule mol = products.getMolecule(i);
            idList.addAll(AtomContainerManipulator.getAllIDs(mol));
        }
        return idList;
    }

    @TestMethod(value="testGetRelevantAtomContainer_IReaction_IAtom")
    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IAtom atom) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer((IAtomContainerSet)reaction.getReactants(), atom);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer((IAtomContainerSet)reaction.getProducts(), atom);
    }

    @TestMethod(value="testGetRelevantAtomContainer_IReaction_IBond")
    public static IAtomContainer getRelevantAtomContainer(IReaction reaction, IBond bond) {
        IAtomContainer result = MoleculeSetManipulator.getRelevantAtomContainer((IAtomContainerSet)reaction.getReactants(), bond);
        if (result != null) {
            return result;
        }
        return MoleculeSetManipulator.getRelevantAtomContainer((IAtomContainerSet)reaction.getProducts(), bond);
    }

    @TestMethod(value="testSetAtomProperties_IReactionSet_Object_Object")
    public static void setAtomProperties(IReaction reaction, Object propKey, Object propVal) {
        IMoleculeSet reactants = reaction.getReactants();
        for (int j = 0; j < reactants.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(reactants.getMolecule(j), propKey, propVal);
        }
        IMoleculeSet products = reaction.getProducts();
        for (int j = 0; j < products.getAtomContainerCount(); ++j) {
            AtomContainerManipulator.setAtomProperties(products.getMolecule(j), propKey, propVal);
        }
    }

    @TestMethod(value="testGetAllChemObjects_IReactionSet")
    public static List<IChemObject> getAllChemObjects(IReaction reaction) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        list.add(reaction);
        IMoleculeSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            list.add(reactants.getMolecule(i));
        }
        IMoleculeSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            list.add(products.getMolecule(i));
        }
        return list;
    }

    @TestMethod(value="testGetMappedChemObject_IReaction_IAtom,testGetMappedChemObject_IReaction_IBond")
    public static IChemObject getMappedChemObject(IReaction reaction, IChemObject chemObject) {
        for (IMapping mapping : reaction.mappings()) {
            if (mapping.getChemObject(0).equals(chemObject)) {
                return mapping.getChemObject(1);
            }
            if (!mapping.getChemObject(1).equals(chemObject)) continue;
            return mapping.getChemObject(0);
        }
        return null;
    }
}

