/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphAddList;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.Iterator;
import java.util.Map;

public abstract class FragmentTripleIterator<T>
extends NiceIterator<Triple> {
    private final GraphAddList pending;
    private final Iterator<Map.Entry<Node, T>> it;

    public FragmentTripleIterator(Triple match, Iterator<Map.Entry<Node, T>> it) {
        this.it = it;
        this.pending = new GraphAddList(match);
    }

    @Override
    public boolean hasNext() {
        this.refill();
        return this.pending.size() > 0;
    }

    @Override
    public Triple next() {
        this.ensureHasNext();
        return this.pending.removeLast();
    }

    protected abstract void fill(GraphAdd var1, Node var2, T var3);

    private void refill() {
        while (this.pending.size() == 0 && this.it.hasNext()) {
            this.refillFrom(this.pending, this.it.next());
        }
    }

    protected void refillFrom(GraphAdd pending, Map.Entry<Node, T> x) {
        this.fill(pending, x.getKey(), x.getValue());
    }
}

