/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.shared.AlreadyExistsException;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.HashMap;
import java.util.Map;

public class SimpleGraphMaker
extends BaseGraphMaker {
    private Map<String, Graph> graphs = new HashMap<String, Graph>();

    public SimpleGraphMaker(ReificationStyle style) {
        super(style);
    }

    public SimpleGraphMaker() {
        this(ReificationStyle.Minimal);
    }

    public Graph create() {
        return Factory.createGraphMem();
    }

    @Override
    public Graph createGraph(String name, boolean strict) {
        GraphMemBase already = (GraphMemBase)this.graphs.get(name);
        if (already == null) {
            Graph result = Factory.createGraphMem(this.style);
            this.graphs.put(name, result);
            return result;
        }
        if (strict) {
            throw new AlreadyExistsException(name);
        }
        return already.openAgain();
    }

    @Override
    public Graph openGraph(String name, boolean strict) {
        GraphMemBase already = (GraphMemBase)this.graphs.get(name);
        if (already == null) {
            if (strict) {
                throw new DoesNotExistException(name);
            }
            return this.createGraph(name, true);
        }
        return already.openAgain();
    }

    @Override
    public Graph openGraph() {
        return this.getGraph();
    }

    @Override
    public void removeGraph(String name) {
        if (!this.graphs.containsKey(name)) {
            throw new DoesNotExistException(name);
        }
        this.graphs.remove(name);
    }

    @Override
    public boolean hasGraph(String name) {
        return this.graphs.containsKey(name);
    }

    @Override
    public void close() {
    }

    @Override
    public ExtendedIterator<String> listGraphs() {
        return WrappedIterator.create(this.graphs.keySet().iterator());
    }
}

