/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import org.openscience.cdk.depict.Depiction;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.MolGridDepiction;
import org.openscience.cdk.depict.ReactionDepiction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.SymbolVisibility;
import org.openscience.cdk.renderer.color.CDK2DAtomColors;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.standard.SelectionVisibility;
import org.openscience.cdk.renderer.generators.standard.StandardGenerator;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class DepictionGenerator {
    private static final Color[] KELLY_MAX_CONTRAST = new Color[]{new Color(21386), new Color(9677312), new Color(12648480), new Color(16757504), new Color(32052), new Color(16738304), new Color(13541986), new Color(8482918), new Color(10927575), new Color(8404597), new Color(16152206), new Color(16743004), new Color(5453690), new Color(16748032), new Color(11741265), new Color(16041984), new Color(8329229), new Color(5845781), new Color(15809043), new Color(2305046)};
    public static double AUTOMATIC = -1.0;
    public static double DEFAULT_MM_MARGIN = 0.56;
    public static double DEFAULT_PX_MARGIN = 4.0;
    private Dimensions dimensions = Dimensions.AUTOMATIC;
    private final Map<Class<? extends IGeneratorParameter>, IGeneratorParameter<?>> params = new HashMap();
    private final Font font;
    private final List<IGenerator<IAtomContainer>> gens = new ArrayList<IGenerator<IAtomContainer>>();
    private final StructureDiagramGenerator sdg = new StructureDiagramGenerator();
    private boolean annotateAtomNum = false;
    private boolean annotateAtomMap = false;
    private boolean highlightAtomMap = false;
    private Color[] atomMapColors = null;
    private Map<IChemObject, Color> highlight = new HashMap<IChemObject, Color>();

    public DepictionGenerator() {
        this(new Font(DepictionGenerator.getDefaultOsFont(), 0, 13));
        this.setParam(BasicSceneGenerator.BondLength.class, 26.1);
        this.setParam(StandardGenerator.HashSpacing.class, 3.25);
        this.setParam(StandardGenerator.WaveSpacing.class, 3.25);
    }

    public DepictionGenerator(Font font) {
        this.gens.add(new BasicSceneGenerator());
        this.font = font;
        this.gens.add(new StandardGenerator(this.font));
        for (IGenerator<IAtomContainer> iGenerator : this.gens) {
            for (IGeneratorParameter<?> param : iGenerator.getParameters()) {
                this.params.put(param.getClass(), param);
            }
        }
        for (IGeneratorParameter iGeneratorParameter : new RendererModel().getRenderingParameters()) {
            this.params.put(iGeneratorParameter.getClass(), iGeneratorParameter);
        }
        this.setParam(BasicSceneGenerator.Margin.class, AUTOMATIC);
        this.setParam(RendererModel.Padding.class, AUTOMATIC);
        this.sdg.setUseTemplates(false);
    }

    private DepictionGenerator(DepictionGenerator org) {
        this.annotateAtomMap = org.annotateAtomMap;
        this.annotateAtomNum = org.annotateAtomNum;
        this.highlightAtomMap = org.highlightAtomMap;
        this.atomMapColors = org.atomMapColors;
        this.dimensions = org.dimensions;
        this.font = org.font;
        this.highlight.putAll(org.highlight);
        this.gens.addAll(org.gens);
        this.params.putAll(org.params);
    }

    private <U, T extends IGeneratorParameter<U>> U getParameterValue(Class<T> key) {
        IGeneratorParameter<?> param = this.params.get(key);
        if (param == null) {
            throw new IllegalArgumentException("No parameter registered: " + key + " " + this.params.keySet());
        }
        return (U)param.getValue();
    }

    private <T extends IGeneratorParameter<S>, S, U extends S> void setParam(Class<T> key, U val) {
        IGeneratorParameter param = null;
        try {
            param = (IGeneratorParameter)key.newInstance();
            param.setValue(val);
            this.params.put(key, param);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LoggingToolFactory.createLoggingTool(this.getClass()).error("Could not copy rendering parameter: " + key);
        }
    }

    private RendererModel getModel() {
        RendererModel model = new RendererModel();
        for (IGenerator<IAtomContainer> iGenerator : this.gens) {
            model.registerParameters(iGenerator);
        }
        for (IGeneratorParameter iGeneratorParameter : this.params.values()) {
            model.set(iGeneratorParameter.getClass(), iGeneratorParameter.getValue());
        }
        return model;
    }

    public Depiction depict(IAtomContainer mol) throws CDKException {
        return this.depict(Collections.singleton(mol), 1, 1);
    }

    public Depiction depict(Iterable<IAtomContainer> mols) throws CDKException {
        int nMols = FluentIterable.from(mols).size();
        Dimension grid = Dimensions.determineGrid(nMols);
        return this.depict(mols, grid.height, grid.width);
    }

    public Depiction depict(Iterable<IAtomContainer> mols, int nrow, int ncol) throws CDKException {
        int molId = 0;
        for (IAtomContainer iAtomContainer : mols) {
            DepictionGenerator.setIfMissing(iAtomContainer, MarkedElement.ID_KEY, "mol" + ++molId);
        }
        List<Double> scaleFactors = this.prepareCoords(mols);
        for (Map.Entry<IChemObject, Color> entry : this.highlight.entrySet()) {
            entry.getKey().setProperty("stdgen.highlight.color", entry.getValue());
        }
        ImmutableList<IAtomContainer> immutableList = FluentIterable.from(mols).toList();
        DepictionGenerator depictionGenerator = this.withParam(BasicSceneGenerator.Scale.class, this.caclModelScale(immutableList));
        RendererModel model = depictionGenerator.getModel();
        List<Bounds> molElems = depictionGenerator.generate(immutableList, model, 1);
        DepictionGenerator.resetCoords(mols, scaleFactors);
        ArrayList<Bounds> titles = new ArrayList<Bounds>();
        if (((Boolean)depictionGenerator.getParameterValue(BasicSceneGenerator.ShowMoleculeTitle.class)).booleanValue()) {
            for (IAtomContainer mol : mols) {
                titles.add(depictionGenerator.generateTitle(mol));
            }
        }
        for (IChemObject obj : this.highlight.keySet()) {
            obj.removeProperty("stdgen.highlight.color");
        }
        this.highlight.clear();
        return new MolGridDepiction(model, molElems, titles, this.dimensions, nrow, ncol);
    }

    private List<Double> prepareCoords(Iterable<IAtomContainer> mols) throws CDKException {
        ArrayList<Double> scaleFactors = new ArrayList<Double>();
        for (IAtomContainer mol : mols) {
            if (this.ensure2dLayout(mol)) {
                scaleFactors.add(Double.NaN);
                continue;
            }
            if (mol.getBondCount() > 0) {
                double factor = GeometryUtil.getScaleFactor(mol, 1.5);
                GeometryUtil.scaleMolecule(mol, factor);
                scaleFactors.add(factor);
                continue;
            }
            scaleFactors.add(1.0);
        }
        return scaleFactors;
    }

    private static void resetCoords(Iterable<IAtomContainer> mols, List<Double> scales) {
        Iterator<Double> it = scales.iterator();
        for (IAtomContainer mol : mols) {
            double factor = it.next();
            if (!Double.isNaN(factor)) {
                GeometryUtil.scaleMolecule(mol, 1.0 / factor);
                continue;
            }
            for (IAtom atom : mol.atoms()) {
                atom.setPoint2d(null);
            }
        }
    }

    private static void setIfMissing(IChemObject chemObject, String key, String val) {
        if (chemObject.getProperty(key) == null) {
            chemObject.setProperty(key, val);
        }
    }

    public Depiction depict(IReaction rxn) throws CDKException {
        Color fgcol = ((IAtomColorer)this.getParameterValue(StandardGenerator.AtomColor.class)).getAtomColor(rxn.getBuilder().newInstance(IAtom.class, "C"));
        List<IAtomContainer> reactants = this.toList(rxn.getReactants());
        List<IAtomContainer> products = this.toList(rxn.getProducts());
        List<IAtomContainer> agents = this.toList(rxn.getAgents());
        int molId = 0;
        for (IAtomContainer mol : reactants) {
            DepictionGenerator.setIfMissing(mol, MarkedElement.ID_KEY, "mol" + ++molId);
            DepictionGenerator.setIfMissing(mol, MarkedElement.CLASS_KEY, "reactant");
        }
        for (IAtomContainer mol : products) {
            DepictionGenerator.setIfMissing(mol, MarkedElement.ID_KEY, "mol" + ++molId);
            DepictionGenerator.setIfMissing(mol, MarkedElement.CLASS_KEY, "product");
        }
        for (IAtomContainer mol : agents) {
            DepictionGenerator.setIfMissing(mol, MarkedElement.ID_KEY, "mol" + ++molId);
            DepictionGenerator.setIfMissing(mol, MarkedElement.CLASS_KEY, "agent");
        }
        HashMap<IChemObject, Color> myHighlight = new HashMap<IChemObject, Color>();
        if (this.highlightAtomMap) {
            myHighlight.putAll(this.makeHighlightAtomMap(reactants, products));
        }
        myHighlight.putAll(this.highlight);
        this.highlight.clear();
        List<Double> reactantScales = this.prepareCoords(reactants);
        List<Double> productScales = this.prepareCoords(products);
        List<Double> agentScales = this.prepareCoords(agents);
        for (Map.Entry e : myHighlight.entrySet()) {
            ((IChemObject)e.getKey()).setProperty("stdgen.highlight.color", e.getValue());
        }
        double scale = this.caclModelScale(rxn);
        DepictionGenerator copy = this.withParam(BasicSceneGenerator.Scale.class, scale);
        RendererModel model = copy.getModel();
        List<Bounds> reactantBounds = copy.generate(reactants, model, 1);
        List<Bounds> productBounds = copy.generate(this.toList(rxn.getProducts()), model, rxn.getReactantCount());
        List<Bounds> agentBounds = copy.generate(this.toList(rxn.getAgents()), model, rxn.getReactantCount() + rxn.getProductCount());
        for (IChemObject obj : myHighlight.keySet()) {
            obj.removeProperty("stdgen.highlight.color");
        }
        Bounds plus = copy.generatePlusSymbol(scale, fgcol);
        DepictionGenerator.resetCoords(reactants, reactantScales);
        DepictionGenerator.resetCoords(products, productScales);
        DepictionGenerator.resetCoords(agents, agentScales);
        Bounds emptyBounds = new Bounds();
        Bounds title = (Boolean)copy.getParameterValue(BasicSceneGenerator.ShowReactionTitle.class) != false ? copy.generateTitle(rxn) : emptyBounds;
        ArrayList<Bounds> reactantTitles = new ArrayList<Bounds>();
        ArrayList<Bounds> productTitles = new ArrayList<Bounds>();
        if (((Boolean)copy.getParameterValue(BasicSceneGenerator.ShowMoleculeTitle.class)).booleanValue()) {
            for (IAtomContainer reactant : reactants) {
                reactantTitles.add(copy.generateTitle(reactant));
            }
            for (IAtomContainer product : products) {
                productTitles.add(copy.generateTitle(product));
            }
        }
        Bounds conditions = this.generateReactionConditions(rxn, fgcol);
        return new ReactionDepiction(model, reactantBounds, productBounds, agentBounds, plus, rxn.getDirection(), this.dimensions, reactantTitles, productTitles, title, conditions, fgcol);
    }

    private Map<IChemObject, Color> makeHighlightAtomMap(List<IAtomContainer> reactants, List<IAtomContainer> products) {
        HashMap<IChemObject, Color> colorMap = new HashMap<IChemObject, Color>();
        HashMap<Integer, Color> mapToColor = new HashMap<Integer, Color>();
        int colorIdx = -1;
        for (IAtomContainer mol : reactants) {
            int prevPalletIdx = colorIdx;
            for (IAtom atom : mol.atoms()) {
                int mapidx = this.accessAtomMap(atom);
                if (mapidx <= 0) continue;
                if (prevPalletIdx == colorIdx && ++colorIdx >= this.atomMapColors.length) {
                    throw new IllegalArgumentException("Not enough colors to highlight atom mapping, please provide mode");
                }
                Color color = this.atomMapColors[colorIdx];
                colorMap.put(atom, color);
                mapToColor.put(mapidx, color);
            }
            if (colorIdx <= prevPalletIdx) continue;
            for (IBond bond : mol.bonds()) {
                IAtom a1 = bond.getAtom(0);
                IAtom a2 = bond.getAtom(1);
                Color c1 = (Color)colorMap.get(a1);
                Color c2 = (Color)colorMap.get(a2);
                if (c1 == null || c1 != c2) continue;
                colorMap.put(bond, c1);
            }
        }
        for (IAtomContainer mol : products) {
            for (IAtom atom : mol.atoms()) {
                int mapidx = this.accessAtomMap(atom);
                if (mapidx <= 0) continue;
                colorMap.put(atom, (Color)mapToColor.get(mapidx));
            }
            for (IBond bond : mol.bonds()) {
                IAtom a1 = bond.getAtom(0);
                IAtom a2 = bond.getAtom(1);
                Color c1 = (Color)colorMap.get(a1);
                Color c2 = (Color)colorMap.get(a2);
                if (c1 == null || c1 != c2) continue;
                colorMap.put(bond, c1);
            }
        }
        return colorMap;
    }

    private Integer accessAtomMap(IAtom atom) {
        Integer mapidx = atom.getProperty("cdk:AtomAtomMapping", Integer.class);
        if (mapidx == null) {
            return 0;
        }
        return mapidx;
    }

    private Bounds generatePlusSymbol(double scale, Color fgcol) {
        return new Bounds(StandardGenerator.embedText(this.font, "+", fgcol, 1.0 / scale));
    }

    private List<IAtomContainer> toList(IAtomContainerSet set) {
        return FluentIterable.from(set.atomContainers()).toList();
    }

    private IRenderingElement generate(IAtomContainer molecule, RendererModel model, int atomNum) throws CDKException {
        String molId = (String)molecule.getProperty(MarkedElement.ID_KEY);
        if (molId != null) {
            int atomId = 0;
            int bondid = 0;
            for (IAtom atom : molecule.atoms()) {
                DepictionGenerator.setIfMissing(atom, MarkedElement.ID_KEY, molId + "atm" + ++atomId);
            }
            for (IBond bond : molecule.bonds()) {
                DepictionGenerator.setIfMissing(bond, MarkedElement.ID_KEY, molId + "bnd" + ++bondid);
            }
        }
        if (this.annotateAtomNum) {
            for (IAtom atom : molecule.atoms()) {
                if (atom.getProperty("stdgen.annotation.label") != null) {
                    throw new UnsupportedOperationException("Multiple annotation labels are not supported.");
                }
                atom.setProperty("stdgen.annotation.label", Integer.toString(atomNum++));
            }
        } else if (this.annotateAtomMap) {
            for (IAtom atom : molecule.atoms()) {
                if (atom.getProperty("stdgen.annotation.label") != null) {
                    throw new UnsupportedOperationException("Multiple annotation labels are not supported.");
                }
                int mapidx = this.accessAtomMap(atom);
                if (mapidx <= 0) continue;
                atom.setProperty("stdgen.annotation.label", Integer.toString(mapidx));
            }
        }
        ElementGroup grp = new ElementGroup();
        for (IGenerator<IAtomContainer> gen : this.gens) {
            grp.add(gen.generate(molecule, model));
        }
        if (this.annotateAtomNum || this.annotateAtomMap) {
            for (IAtom atom : molecule.atoms()) {
                atom.removeProperty("stdgen.annotation.label");
            }
        }
        return grp;
    }

    private List<Bounds> generate(List<IAtomContainer> mols, RendererModel model, int atomNum) throws CDKException {
        ArrayList<Bounds> elems = new ArrayList<Bounds>();
        boolean num = false;
        for (IAtomContainer mol : mols) {
            elems.add(new Bounds(this.generate(mol, model, atomNum)));
            atomNum += mol.getAtomCount();
        }
        return elems;
    }

    private Bounds generateTitle(IChemObject chemObj) {
        String title = (String)chemObj.getProperty("cdk:Title");
        if (title == null || title.isEmpty()) {
            return new Bounds();
        }
        double scale = 1.0 / (Double)this.getParameterValue(BasicSceneGenerator.Scale.class) * (Double)this.getParameterValue(RendererModel.TitleFontScale.class);
        return new Bounds(MarkedElement.markup(StandardGenerator.embedText(this.font, title, (Color)this.getParameterValue(RendererModel.TitleColor.class), scale), "title"));
    }

    private Bounds generateReactionConditions(IReaction chemObj, Color fg) {
        String title = (String)chemObj.getProperty("cdk:ReactionConditions");
        if (title == null || title.isEmpty()) {
            return new Bounds();
        }
        double scale = 1.0 / (Double)this.getParameterValue(BasicSceneGenerator.Scale.class);
        return new Bounds(MarkedElement.markup(StandardGenerator.embedText(this.font, title, fg, scale), "conditions"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensure2dLayout(IAtomContainer container) throws CDKException {
        if (!GeometryUtil.has2DCoordinates(container)) {
            StructureDiagramGenerator structureDiagramGenerator = this.sdg;
            synchronized (structureDiagramGenerator) {
                this.sdg.setMolecule(container, false);
                this.sdg.generateCoordinates();
            }
            return true;
        }
        return false;
    }

    private void ensure2dLayout(IReaction rxn) throws CDKException {
        for (IAtomContainer mol : rxn.getReactants().atomContainers()) {
            this.ensure2dLayout(mol);
        }
        for (IAtomContainer mol : rxn.getProducts().atomContainers()) {
            this.ensure2dLayout(mol);
        }
        for (IAtomContainer mol : rxn.getAgents().atomContainers()) {
            this.ensure2dLayout(mol);
        }
    }

    public DepictionGenerator withAtomColors() {
        return this.withAtomColors(new CDK2DAtomColors());
    }

    public DepictionGenerator withAtomColors(IAtomColorer colorer) {
        return this.withParam(StandardGenerator.AtomColor.class, colorer);
    }

    public DepictionGenerator withBackgroundColor(Color color) {
        return this.withParam(BasicSceneGenerator.BackgroundColor.class, color);
    }

    public DepictionGenerator withOuterGlowHighlight() {
        return this.withOuterGlowHighlight(4.0);
    }

    public DepictionGenerator withOuterGlowHighlight(double width) {
        return this.withParam(StandardGenerator.Highlighting.class, StandardGenerator.HighlightStyle.OuterGlow).withParam(StandardGenerator.OuterGlowWidth.class, width);
    }

    public DepictionGenerator withAtomNumbers() {
        if (this.annotateAtomMap) {
            throw new IllegalArgumentException();
        }
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.annotateAtomNum = true;
        return copy;
    }

    public DepictionGenerator withAtomMapNumbers() {
        if (this.annotateAtomNum) {
            throw new IllegalArgumentException();
        }
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.annotateAtomMap = true;
        return copy;
    }

    public DepictionGenerator withAtomMapHighlight() {
        return this.withAtomMapHighlight(KELLY_MAX_CONTRAST);
    }

    public DepictionGenerator withAtomMapHighlight(Color[] colors) {
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.highlightAtomMap = true;
        copy.atomMapColors = Arrays.copyOf(colors, colors.length);
        return copy;
    }

    public DepictionGenerator withMolTitle() {
        return this.withParam(BasicSceneGenerator.ShowMoleculeTitle.class, true);
    }

    public DepictionGenerator withRxnTitle() {
        return this.withParam(BasicSceneGenerator.ShowReactionTitle.class, true);
    }

    public DepictionGenerator withAnnotationColor(Color color) {
        return this.withParam(StandardGenerator.AnnotationColor.class, color);
    }

    public DepictionGenerator withAnnotationScale(double scale) {
        return this.withParam(StandardGenerator.AnnotationFontScale.class, scale);
    }

    public DepictionGenerator withTitleColor(Color color) {
        return this.withParam(RendererModel.TitleColor.class, color);
    }

    public DepictionGenerator withTitleScale(double scale) {
        return this.withParam(RendererModel.TitleFontScale.class, scale);
    }

    public DepictionGenerator withTerminalCarbons() {
        return this.withParam(StandardGenerator.Visibility.class, SelectionVisibility.disconnected(SymbolVisibility.iupacRecommendations()));
    }

    public DepictionGenerator withCarbonSymbols() {
        return this.withParam(StandardGenerator.Visibility.class, SymbolVisibility.all());
    }

    public DepictionGenerator withHighlight(Iterable<? extends IChemObject> chemObjs, Color color) {
        DepictionGenerator copy = new DepictionGenerator(this);
        for (IChemObject iChemObject : chemObjs) {
            copy.highlight.put(iChemObject, color);
        }
        return copy;
    }

    public DepictionGenerator withSize(double w, double h) {
        if (w < 0.0 && h >= 0.0 || h < 0.0 && w >= 0.0) {
            throw new IllegalArgumentException("Width and height must either both be automatic or both specified");
        }
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.dimensions = w == AUTOMATIC ? Dimensions.AUTOMATIC : new Dimensions(w, h);
        return copy;
    }

    public DepictionGenerator withMargin(double m) {
        return this.withParam(BasicSceneGenerator.Margin.class, m);
    }

    public DepictionGenerator withPadding(double p) {
        return this.withParam(RendererModel.Padding.class, p);
    }

    public DepictionGenerator withZoom(double zoom) {
        return this.withParam(BasicSceneGenerator.ZoomFactor.class, zoom);
    }

    public DepictionGenerator withFillToFit() {
        return this.withParam(BasicSceneGenerator.FitToScreen.class, true);
    }

    public <T extends IGeneratorParameter<S>, S, U extends S> DepictionGenerator withParam(Class<T> key, U value) {
        DepictionGenerator copy = new DepictionGenerator(this);
        copy.setParam(key, value);
        return copy;
    }

    private double caclModelScale(Collection<IAtomContainer> mols) {
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        for (IAtomContainer mol : mols) {
            for (IBond bond : mol.bonds()) {
                bonds.add(bond);
            }
        }
        return this.calcModelScaleForBondLength(this.medianBondLength(bonds));
    }

    private double caclModelScale(IReaction rxn) {
        ArrayList<IAtomContainer> mols = new ArrayList<IAtomContainer>();
        for (IAtomContainer mol : rxn.getReactants().atomContainers()) {
            mols.add(mol);
        }
        for (IAtomContainer mol : rxn.getProducts().atomContainers()) {
            mols.add(mol);
        }
        for (IAtomContainer mol : rxn.getAgents().atomContainers()) {
            mols.add(mol);
        }
        return this.caclModelScale(mols);
    }

    private double medianBondLength(Collection<IBond> bonds) {
        if (bonds.isEmpty()) {
            return 1.5;
        }
        int nBonds = 0;
        double[] lengths = new double[bonds.size()];
        for (IBond bond : bonds) {
            Point2d p2;
            Point2d p1 = bond.getAtom(0).getPoint2d();
            if (p1.equals(p2 = bond.getAtom(1).getPoint2d())) continue;
            lengths[nBonds++] = p1.distance(p2);
        }
        Arrays.sort(lengths, 0, nBonds);
        return lengths[nBonds / 2];
    }

    private double calcModelScaleForBondLength(double bondLength) {
        return (Double)this.getParameterValue(BasicSceneGenerator.BondLength.class) / bondLength;
    }

    private static String getDefaultOsFont() {
        return "SansSerif";
    }
}

