/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.interfaces;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;

public interface IAtomContainer
extends IChemObject,
IChemObjectListener {
    public void addStereoElement(IStereoElement var1);

    public void setStereoElements(List<IStereoElement> var1);

    public Iterable<IStereoElement> stereoElements();

    public void setAtoms(IAtom[] var1);

    public void setBonds(IBond[] var1);

    public void setAtom(int var1, IAtom var2);

    public IAtom getAtom(int var1);

    public IBond getBond(int var1);

    public ILonePair getLonePair(int var1);

    public ISingleElectron getSingleElectron(int var1);

    public Iterable<IAtom> atoms();

    public Iterable<IBond> bonds();

    public Iterable<ILonePair> lonePairs();

    public Iterable<ISingleElectron> singleElectrons();

    public Iterable<IElectronContainer> electronContainers();

    public IAtom getFirstAtom();

    public IAtom getLastAtom();

    public int getAtomNumber(IAtom var1);

    public int getBondNumber(IAtom var1, IAtom var2);

    public int getBondNumber(IBond var1);

    public int getLonePairNumber(ILonePair var1);

    public int getSingleElectronNumber(ISingleElectron var1);

    public IElectronContainer getElectronContainer(int var1);

    public IBond getBond(IAtom var1, IAtom var2);

    public int getAtomCount();

    public int getBondCount();

    public int getLonePairCount();

    public int getSingleElectronCount();

    public int getElectronContainerCount();

    public List<IAtom> getConnectedAtomsList(IAtom var1);

    public List<IBond> getConnectedBondsList(IAtom var1);

    public List<ILonePair> getConnectedLonePairsList(IAtom var1);

    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom var1);

    public List<IElectronContainer> getConnectedElectronContainersList(IAtom var1);

    public int getConnectedAtomsCount(IAtom var1);

    public int getConnectedBondsCount(IAtom var1);

    public int getConnectedBondsCount(int var1);

    public int getConnectedLonePairsCount(IAtom var1);

    public int getConnectedSingleElectronsCount(IAtom var1);

    public double getBondOrderSum(IAtom var1);

    public IBond.Order getMaximumBondOrder(IAtom var1);

    public IBond.Order getMinimumBondOrder(IAtom var1);

    public void add(IAtomContainer var1);

    public void addAtom(IAtom var1);

    public void addBond(IBond var1);

    public void addLonePair(ILonePair var1);

    public void addSingleElectron(ISingleElectron var1);

    public void addElectronContainer(IElectronContainer var1);

    public void remove(IAtomContainer var1);

    public void removeAtom(int var1);

    public void removeAtom(IAtom var1);

    public IBond removeBond(int var1);

    public IBond removeBond(IAtom var1, IAtom var2);

    public void removeBond(IBond var1);

    public ILonePair removeLonePair(int var1);

    public void removeLonePair(ILonePair var1);

    public ISingleElectron removeSingleElectron(int var1);

    public void removeSingleElectron(ISingleElectron var1);

    public IElectronContainer removeElectronContainer(int var1);

    public void removeElectronContainer(IElectronContainer var1);

    public void removeAtomAndConnectedElectronContainers(IAtom var1);

    public void removeAllElements();

    public void removeAllElectronContainers();

    public void removeAllBonds();

    public void addBond(int var1, int var2, IBond.Order var3, IBond.Stereo var4);

    public void addBond(int var1, int var2, IBond.Order var3);

    public void addLonePair(int var1);

    public void addSingleElectron(int var1);

    public boolean contains(IAtom var1);

    public boolean contains(IBond var1);

    public boolean contains(ILonePair var1);

    public boolean contains(ISingleElectron var1);

    public boolean contains(IElectronContainer var1);

    public boolean isEmpty();

    @Override
    public IAtomContainer clone() throws CloneNotSupportedException;
}

