/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import java.util.List;
import org.openscience.cdk.io.formats.AbstractResourceFormat;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

public class PubChemCompoundXMLFormat
extends AbstractResourceFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new PubChemCompoundXMLFormat();
        }
        return myself;
    }

    @Override
    public String getFormatName() {
        return "PubChem Compound XML";
    }

    @Override
    public String getMIMEType() {
        return null;
    }

    @Override
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    public String[] getNameExtensions() {
        return new String[]{"xml"};
    }

    @Override
    public String getReaderClassName() {
        return "org.openscience.cdk.io.PCCompoundXMLReader";
    }

    @Override
    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean isXMLBased() {
        return true;
    }

    @Override
    public int getSupportedDataFeatures() {
        return 0;
    }

    @Override
    public int getRequiredDataFeatures() {
        return 0;
    }

    @Override
    public IChemFormatMatcher.MatchResult matches(List<String> lines) {
        IChemFormatMatcher.MatchResult result = NO_MATCH;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.contains("<PC-Compound") && result == NO_MATCH) {
                result = new IChemFormatMatcher.MatchResult(true, this, i);
            }
            if (!line.contains("<PC-Compounds")) continue;
            return NO_MATCH;
        }
        return result;
    }
}

