/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.HashSet;
import java.util.Set;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.AllPairsShortestPaths;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class LargestChainDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private boolean checkRingSystem = false;
    private static final String[] NAMES = new String[]{"nAtomLC"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#largestChain", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 2) {
            throw new CDKException("LargestChainDescriptor only expects two parameter");
        }
        if (!(params[0] instanceof Boolean) || !(params[1] instanceof Boolean)) {
            throw new CDKException("Both parameters must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
        this.checkRingSystem = (Boolean)params[1];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity, this.checkRingSystem};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        if (this.checkRingSystem) {
            Cycles.markRingAtomsAndBonds(atomContainer);
        }
        HashSet<IAtom> included = new HashSet<IAtom>();
        for (IAtom atom : atomContainer.atoms()) {
            if (atom.isInRing() || atom.getAtomicNumber() == 1) continue;
            included.add(atom);
        }
        IAtomContainer subset = LargestChainDescriptor.subsetMol(atomContainer, included);
        AllPairsShortestPaths apsp = new AllPairsShortestPaths(subset);
        int max = 0;
        int numAtoms = subset.getAtomCount();
        for (int i = 0; i < numAtoms; ++i) {
            for (int j = i + 1; j < numAtoms; ++j) {
                int len = apsp.from(i).pathTo(j).length;
                if (len <= max) continue;
                max = len;
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(max), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity", "checkRingSystem"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return true;
    }

    private static IAtomContainer subsetMol(IAtomContainer mol, Set<IAtom> include) {
        IAtomContainer cpy = mol.getBuilder().newInstance(IAtomContainer.class, mol.getAtomCount(), mol.getBondCount(), 0, 0);
        for (IAtom atom : mol.atoms()) {
            if (!include.contains(atom)) continue;
            cpy.addAtom(atom);
        }
        for (IBond bond : mol.bonds()) {
            if (!include.contains(bond.getAtom(0)) || !include.contains(bond.getAtom(1))) continue;
            cpy.addBond(bond);
        }
        return cpy;
    }
}

