/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;

public class DoubleBondStereochemistry
implements IDoubleBondStereochemistry {
    private IDoubleBondStereochemistry.Conformation stereo;
    private IBond[] ligandBonds;
    private IBond stereoBond;
    private IChemObjectBuilder builder;

    public DoubleBondStereochemistry(IBond stereoBond, IBond[] ligandBonds, IDoubleBondStereochemistry.Conformation stereo) {
        if (ligandBonds.length > 2) {
            throw new IllegalArgumentException("expected two ligand bonds");
        }
        this.stereoBond = stereoBond;
        this.ligandBonds = ligandBonds;
        this.stereo = stereo;
    }

    public void setBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public IBond[] getBonds() {
        IBond[] arrayCopy = new IBond[2];
        System.arraycopy(this.ligandBonds, 0, arrayCopy, 0, 2);
        return arrayCopy;
    }

    @Override
    public IBond getStereoBond() {
        return this.stereoBond;
    }

    @Override
    public IDoubleBondStereochemistry.Conformation getStereo() {
        return this.stereo;
    }

    @Override
    public boolean contains(IAtom atom) {
        return this.stereoBond.contains(atom) || this.ligandBonds[0].contains(atom) || this.ligandBonds[1].contains(atom);
    }

    @Override
    public IDoubleBondStereochemistry map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        if (bonds == null) {
            throw new IllegalArgumentException("null bond mapping provided");
        }
        IBond doubleBond = this.stereoBond != null ? bonds.get(this.stereoBond) : null;
        IBond[] connected = new IBond[this.ligandBonds.length];
        for (int i = 0; i < connected.length; ++i) {
            if (this.ligandBonds[i] == null) continue;
            connected[i] = bonds.get(this.ligandBonds[i]);
        }
        return new DoubleBondStereochemistry(doubleBond, connected, this.stereo);
    }
}

