/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.charges.StabilizationCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.StabilizationPlusChargeDescriptorTest")
public class StabilizationPlusChargeDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] descriptorNames = new String[]{"stabilPlusC"};
    private StabilizationCharges stabil = new StabilizationCharges();

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#stabilizationPlusCharge", this.getClass().getName(), "$Id: 3966274116a28a4f5d33761b51692e1c64d9f52f $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return descriptorNames;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        IAtom localAtom;
        IAtomContainer clone;
        try {
            clone = container.clone();
            localAtom = clone.getAtom(container.getAtomNumber(atom));
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(clone);
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, e);
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), descriptorNames, e);
        }
        double result = this.stabil.calculatePositive(clone, localAtom);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(result), descriptorNames);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

