/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.AllCycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.ringsearch.AllRingsFinderTest")
public final class AllRingsFinder {
    private final Threshold threshold;

    @Deprecated
    public AllRingsFinder(boolean logging) {
        this(Threshold.PubChem_99);
    }

    public AllRingsFinder() {
        this(Threshold.PubChem_99);
    }

    private AllRingsFinder(Threshold threshold) {
        this.threshold = threshold;
    }

    @TestMethod(value="testFindAllRings_IAtomContainer,testBondsWithinRing")
    public IRingSet findAllRings(IAtomContainer container) throws CDKException {
        return this.findAllRings(container, container.getAtomCount());
    }

    public IRingSet findAllRings(IAtomContainer container, int maxRingSize) throws CDKException {
        int m = container.getBondCount();
        HashMap<Edge, IBond> edges = Maps.newHashMapWithExpectedSize(m);
        int[][] graph = this.toGraph(container, edges);
        RingSearch rs = new RingSearch(container, graph);
        IRingSet ringSet = container.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (int[] isolated : rs.isolated()) {
            if (isolated.length > maxRingSize) continue;
            IRing ring = this.toRing(container, edges, GraphUtil.cycle(graph, isolated));
            ringSet.addAtomContainer(ring);
        }
        for (int[] fused : rs.fused()) {
            AllCycles ac = new AllCycles(GraphUtil.subgraph(graph, fused), Math.min(maxRingSize, fused.length), this.threshold.value);
            if (!ac.completed()) {
                throw new CDKException("Threshold exceeded for AllRingsFinder");
            }
            for (int[] path : ac.paths()) {
                IRing ring = this.toRing(container, edges, path, fused);
                ringSet.addAtomContainer(ring);
            }
        }
        return ringSet;
    }

    public IRingSet findAllRingsInIsolatedRingSystem(IAtomContainer container) throws CDKException {
        return this.findAllRingsInIsolatedRingSystem(container, container.getAtomCount());
    }

    public IRingSet findAllRingsInIsolatedRingSystem(IAtomContainer atomContainer, int maxRingSize) throws CDKException {
        int m = atomContainer.getBondCount();
        HashMap<Edge, IBond> edges = Maps.newHashMapWithExpectedSize(m);
        int[][] graph = this.toGraph(atomContainer, edges);
        AllCycles ac = new AllCycles(graph, maxRingSize, this.threshold.value);
        if (!ac.completed()) {
            throw new CDKException("Threshold exceeded for AllRingsFinder");
        }
        IRingSet ringSet = atomContainer.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (int[] path : ac.paths()) {
            ringSet.addAtomContainer(this.toRing(atomContainer, edges, path));
        }
        return ringSet;
    }

    @TestMethod(value="testCheckTimeout")
    @Deprecated
    public void checkTimeout() throws CDKException {
    }

    @TestMethod(value="testSetTimeout_long")
    @Deprecated
    public AllRingsFinder setTimeout(long timeout) {
        System.err.println("AllRingsFinder.setTimeout() is not used, pleaseuse the new threshold values");
        return this;
    }

    @TestMethod(value="testGetTimeout")
    @Deprecated
    public long getTimeout() {
        return 0L;
    }

    private IRing toRing(IAtomContainer container, Map<Edge, IBond> edges, int[] cycle) {
        IRing ring = container.getBuilder().newInstance(IRing.class, 0);
        int len = cycle.length - 1;
        IAtom[] atoms = new IAtom[len];
        IBond[] bonds = new IBond[len];
        for (int i = 0; i < len; ++i) {
            atoms[i] = container.getAtom(cycle[i]);
            bonds[i] = edges.get(new Edge(cycle[i], cycle[i + 1]));
            atoms[i].setFlag(2, true);
        }
        ring.setAtoms(atoms);
        ring.setBonds(bonds);
        return ring;
    }

    private IRing toRing(IAtomContainer container, Map<Edge, IBond> edges, int[] cycle, int[] mapping) {
        IRing ring = container.getBuilder().newInstance(IRing.class, 0);
        int len = cycle.length - 1;
        IAtom[] atoms = new IAtom[len];
        IBond[] bonds = new IBond[len];
        for (int i = 0; i < len; ++i) {
            atoms[i] = container.getAtom(mapping[cycle[i]]);
            bonds[i] = edges.get(new Edge(mapping[cycle[i]], mapping[cycle[i + 1]]));
            atoms[i].setFlag(2, true);
        }
        ring.setAtoms(atoms);
        ring.setBonds(bonds);
        return ring;
    }

    private int[][] toGraph(IAtomContainer container, Map<Edge, IBond> edges) {
        if (container == null) {
            throw new NullPointerException("atom container was null");
        }
        int n = container.getAtomCount();
        int[][] graph = new int[n][4];
        int[] degree = new int[n];
        for (IBond bond : container.bonds()) {
            int v = container.getAtomNumber(bond.getAtom(0));
            int w = container.getAtomNumber(bond.getAtom(1));
            edges.put(new Edge(v, w), bond);
            if (v < 0 || w < 0) {
                throw new IllegalArgumentException("bond at index " + container.getBondNumber(bond) + " contained an atom not pressent in molecule");
            }
            int n2 = v;
            int n3 = degree[n2];
            degree[n2] = n3 + 1;
            graph[v][n3] = w;
            int n4 = w;
            int n5 = degree[n4];
            degree[n4] = n5 + 1;
            graph[w][n5] = v;
            if (degree[v] == graph[v].length) {
                graph[v] = Arrays.copyOf(graph[v], degree[v] * 2);
            }
            if (degree[w] != graph[w].length) continue;
            graph[w] = Arrays.copyOf(graph[w], degree[w] * 2);
        }
        for (int v = 0; v < n; ++v) {
            graph[v] = Arrays.copyOf(graph[v], degree[v]);
        }
        return graph;
    }

    public static AllRingsFinder usingThreshold(Threshold threshold) {
        return new AllRingsFinder(threshold);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Threshold {
        PubChem_95(72),
        PubChem_96(84),
        PubChem_97(126),
        PubChem_98(216),
        PubChem_99(684),
        PubChem_991(882),
        PubChem_992(1062),
        PubChem_993(1440),
        PubChem_994(3072),
        None(Integer.MAX_VALUE);

        private final int value;

        private Threshold(int value) {
            this.value = value;
        }
    }

    private final class Edge {
        private final int u;
        private final int v;

        private Edge(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge that = (Edge)o;
            return this.u == that.u && this.v == that.v || this.u == that.v && this.v == that.u;
        }

        public int hashCode() {
            return this.u ^ this.v;
        }
    }
}

