/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.similarity;

import java.util.Iterator;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.similarity.DistanceMomentTest")
public class DistanceMoment {
    private static Point3d getGeometricCenter(IAtomContainer atomContainer) throws CDKException {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (IAtom atom : atomContainer.atoms()) {
            Point3d p = atom.getPoint3d();
            if (p == null) {
                throw new CDKException("Molecule must have 3D coordinates");
            }
            x += p.x;
            y += p.y;
            z += p.z;
        }
        return new Point3d(x /= (double)atomContainer.getAtomCount(), y /= (double)atomContainer.getAtomCount(), z /= (double)atomContainer.getAtomCount());
    }

    private static float mu1(double[] x) {
        float sum = 0.0f;
        for (double aX : x) {
            sum = (float)((double)sum + aX);
        }
        return sum / (float)x.length;
    }

    private static float mu2(double[] x, double mean) {
        float sum = 0.0f;
        for (double aX : x) {
            sum = (float)((double)sum + (aX - mean) * (aX - mean));
        }
        return sum / (float)(x.length - 1);
    }

    private static float mu3(double[] x, double mean, double sigma) {
        float sum = 0.0f;
        for (double aX : x) {
            sum = (float)((double)sum + (aX - mean) / sigma * ((aX - mean) / sigma) * ((aX - mean) / sigma));
        }
        return sum / (float)x.length;
    }

    @TestMethod(value="testGenerateMoments")
    public static float[] generateMoments(IAtomContainer atomContainer) throws CDKException {
        double d;
        Point3d p;
        IAtom atom;
        int natom = atomContainer.getAtomCount();
        Point3d ctd = DistanceMoment.getGeometricCenter(atomContainer);
        Point3d cst = new Point3d();
        Point3d fct = new Point3d();
        Point3d ftf = new Point3d();
        double[] distCtd = new double[natom];
        double[] distCst = new double[natom];
        double[] distFct = new double[natom];
        double[] distFtf = new double[natom];
        Iterator<IAtom> atoms = atomContainer.atoms().iterator();
        int counter = 0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        while (atoms.hasNext()) {
            atom = atoms.next();
            p = atom.getPoint3d();
            d = p.distance(ctd);
            distCtd[counter++] = d;
            if (d < min) {
                cst.x = p.x;
                cst.y = p.y;
                cst.z = p.z;
                min = d;
            }
            if (!(d > max)) continue;
            fct.x = p.x;
            fct.y = p.y;
            fct.z = p.z;
            max = d;
        }
        atoms = atomContainer.atoms().iterator();
        counter = 0;
        while (atoms.hasNext()) {
            atom = atoms.next();
            p = atom.getPoint3d();
            d = p.distance(cst);
            distCst[counter++] = d;
        }
        atoms = atomContainer.atoms().iterator();
        counter = 0;
        max = Double.MIN_VALUE;
        while (atoms.hasNext()) {
            atom = atoms.next();
            p = atom.getPoint3d();
            d = p.distance(fct);
            distFct[counter++] = d;
            if (!(d > max)) continue;
            ftf.x = p.x;
            ftf.y = p.y;
            ftf.z = p.z;
            max = d;
        }
        atoms = atomContainer.atoms().iterator();
        counter = 0;
        while (atoms.hasNext()) {
            atom = atoms.next();
            p = atom.getPoint3d();
            d = p.distance(ftf);
            distFtf[counter++] = d;
        }
        float[] moments = new float[12];
        float mean = DistanceMoment.mu1(distCtd);
        float sigma2 = DistanceMoment.mu2(distCtd, mean);
        float skewness = DistanceMoment.mu3(distCtd, mean, Math.sqrt(sigma2));
        moments[0] = mean;
        moments[1] = sigma2;
        moments[2] = skewness;
        mean = DistanceMoment.mu1(distCst);
        sigma2 = DistanceMoment.mu2(distCst, mean);
        skewness = DistanceMoment.mu3(distCst, mean, Math.sqrt(sigma2));
        moments[3] = mean;
        moments[4] = sigma2;
        moments[5] = skewness;
        mean = DistanceMoment.mu1(distFct);
        sigma2 = DistanceMoment.mu2(distFct, mean);
        skewness = DistanceMoment.mu3(distFct, mean, Math.sqrt(sigma2));
        moments[6] = mean;
        moments[7] = sigma2;
        moments[8] = skewness;
        mean = DistanceMoment.mu1(distFtf);
        sigma2 = DistanceMoment.mu2(distFtf, mean);
        skewness = DistanceMoment.mu3(distFtf, mean, Math.sqrt(sigma2));
        moments[9] = mean;
        moments[10] = sigma2;
        moments[11] = skewness;
        return moments;
    }

    @TestMethod(value="test3DSim1,test3DSim2")
    public static float calculate(IAtomContainer query2, IAtomContainer target) throws CDKException {
        float[] mom1 = DistanceMoment.generateMoments(query2);
        float[] mom2 = DistanceMoment.generateMoments(target);
        float sum = 0.0f;
        for (int i = 0; i < mom1.length; ++i) {
            sum += Math.abs(mom1[i] - mom2[i]);
        }
        return (float)(1.0 / (1.0 + (double)sum / 12.0));
    }
}

