/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import nu.xom.Document;
import org.xmlcml.cml.base.AttributeGenerator;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.base.ElementGenerator;
import org.xmlcml.cml.base.TypeGenerator;

public class SchemaManager
implements CMLConstants {
    public static final String TYPES_XSD = "org/xmlcml/cml/base/types.xsd";
    public static final String ELEMENTS_XSD = "org/xmlcml/cml/base/elements.xsd";
    public static final String ATTRIBUTEGROUPS_XSD = "org/xmlcml/cml/base/attributes.xsd";
    private AttributeGenerator attributeGenerator = new AttributeGenerator(this);
    private ElementGenerator elementGenerator = new ElementGenerator(this);
    private TypeGenerator typeGenerator = new TypeGenerator(this);
    private String outdir;

    public void readAndCreateIndexesFromSchemaFiles() {
        try {
            Document typeSchemaDoc = CMLUtil.getXMLResource(TYPES_XSD);
            this.typeGenerator.setSchema(typeSchemaDoc.getRootElement());
            this.typeGenerator.addXSDTypes();
            this.typeGenerator.indexSchema();
            Document attributeSchemaDoc = CMLUtil.getXMLResource(ATTRIBUTEGROUPS_XSD);
            this.attributeGenerator.setSchema(attributeSchemaDoc.getRootElement());
            this.attributeGenerator.indexSchema();
            Document elementSchemaDoc = CMLUtil.getXMLResource(ELEMENTS_XSD);
            this.elementGenerator.setSchema(elementSchemaDoc.getRootElement());
            this.elementGenerator.indexSchema();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot index schemas: " + e);
        }
    }

    public AttributeGenerator getAttributeGenerator() {
        return this.attributeGenerator;
    }

    public void setAttributeGenerator(AttributeGenerator attributeGenerator) {
        this.attributeGenerator = attributeGenerator;
    }

    public ElementGenerator getElementGenerator() {
        return this.elementGenerator;
    }

    public void setElementGenerator(ElementGenerator elementGenerator) {
        this.elementGenerator = elementGenerator;
    }

    public TypeGenerator getTypeGenerator() {
        return this.typeGenerator;
    }

    public void setTypeGenerator(TypeGenerator typeGenerator) {
        this.typeGenerator = typeGenerator;
    }

    public String getOutdir() {
        return this.outdir;
    }

    public void setOutdir(String outdir) {
        this.outdir = outdir;
    }
}

