/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.BitMatrix;
import org.openscience.cdk.graph.InitialCycles;

@TestClass(value="org.openscience.cdk.graph.GreedyBasisTest")
final class GreedyBasis {
    private final List<InitialCycles.Cycle> basis;
    private final BitSet edgesOfBasis;
    private final int m;

    GreedyBasis(int n, int m) {
        this.basis = new ArrayList<InitialCycles.Cycle>(n);
        this.edgesOfBasis = new BitSet(m);
        this.m = m;
    }

    @TestMethod(value="unmodifiableMembers")
    final List<InitialCycles.Cycle> members() {
        return Collections.unmodifiableList(this.basis);
    }

    @TestMethod(value="size")
    final int size() {
        return this.members().size();
    }

    @TestMethod(value="add")
    final void add(InitialCycles.Cycle cycle) {
        this.basis.add(cycle);
        this.edgesOfBasis.or(cycle.edgeVector());
    }

    @TestMethod(value="addAll")
    final void addAll(Iterable<InitialCycles.Cycle> cycles) {
        for (InitialCycles.Cycle cycle : cycles) {
            this.add(cycle);
        }
    }

    @TestMethod(value="subsetOfBasis")
    final boolean isSubsetOfBasis(InitialCycles.Cycle cycle) {
        BitSet edgeVector = cycle.edgeVector();
        int intersect = GreedyBasis.and(this.edgesOfBasis, edgeVector).cardinality();
        return intersect == cycle.length();
    }

    @TestMethod(value="independence")
    final boolean isIndependent(InitialCycles.Cycle candidate) {
        if (this.basis.isEmpty() || !this.isSubsetOfBasis(candidate)) {
            return true;
        }
        BitMatrix matrix = BitMatrix.from(this.basis, candidate);
        matrix.eliminate();
        return !matrix.eliminated(this.basis.size());
    }

    private static final BitSet and(BitSet s, BitSet t) {
        BitSet u = (BitSet)s.clone();
        u.and(t);
        return u;
    }
}

