/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.result;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.qsar.result.IntegerArrayResultType;

@TestClass(value="org.openscience.cdk.qsar.result.IntegerArrayResultTest")
public class IntegerArrayResult
extends IntegerArrayResultType {
    private static final long serialVersionUID = 4077762427385735922L;
    private List<Integer> array;

    public IntegerArrayResult() {
        super(0);
        this.array = new ArrayList<Integer>();
    }

    public IntegerArrayResult(int size) {
        super(size);
        this.array = new ArrayList<Integer>(size);
    }

    @TestMethod(value="testAdd_int")
    public void add(int value) {
        this.array.add(value);
    }

    @TestMethod(value="testGet_int")
    public int get(int index) {
        if (index >= this.array.size()) {
            return 0;
        }
        return this.array.get(index);
    }

    @Override
    @TestMethod(value="testSize")
    public int length() {
        return Math.max(super.length(), this.array.size());
    }

    @Override
    @TestMethod(value="testToString")
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.length(); ++i) {
            buf.append(this.get(i));
            if (i + 1 >= this.length()) continue;
            buf.append(",");
        }
        return buf.toString();
    }
}

