/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Real;

public class Angle {
    Range range = Range.UNLIMITED;
    Units type = Units.RADIANS;
    public static final double DEGREES_IN_RADIAN = 57.29577951308232;
    double angle = 0.0;

    public Angle() {
    }

    public Angle(double a) {
        this.angle = a;
    }

    public Angle(double a, Units units) {
        this.angle = units == Units.RADIANS ? a : a / 57.29577951308232;
    }

    public Angle(double y, double x) {
        this.angle = Math.atan2(y, x);
    }

    public Angle(Angle a) {
        this.angle = a.angle;
        this.range = a.range;
        this.type = a.type;
    }

    public void shallowCopy(Angle a) {
        this.range = a.range;
        this.type = a.type;
        this.angle = a.angle;
    }

    public Angle plus(Angle a2) {
        Angle temp = new Angle(this.angle + a2.angle);
        return temp;
    }

    public Angle subtract(Angle a2) {
        Angle temp = new Angle(this.angle - a2.angle);
        return temp;
    }

    public Angle multiplyBy(double f) {
        Angle temp = new Angle(this.angle * f);
        return temp;
    }

    public double cos() {
        return Math.cos(this.angle);
    }

    public double sin() {
        return Math.sin(this.angle);
    }

    public double tan() {
        return Math.tan(this.angle);
    }

    public static double normalise(double angle) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public boolean isEqualTo(double a) {
        return Real.isEqual(Angle.normalise(this.angle), Angle.normalise(a));
    }

    public boolean greaterThan(double a) {
        return Angle.normalise(this.angle) > Angle.normalise(a);
    }

    public boolean greaterThanOrEquals(double a) {
        return Angle.normalise(this.angle) >= Angle.normalise(a);
    }

    public boolean lessThan(double a) {
        return Angle.normalise(this.angle) < Angle.normalise(a);
    }

    public boolean lessThanOrEquals(double a) {
        return Angle.normalise(this.angle) <= Angle.normalise(a);
    }

    public boolean isEqualTo(Angle a) {
        return this.isEqualTo(a.angle);
    }

    public boolean greaterThan(Angle a) {
        return this.greaterThan(a.angle);
    }

    public boolean greaterThanOrEquals(Angle a) {
        return this.greaterThanOrEquals(a.angle);
    }

    public boolean lessThan(Angle a) {
        return this.lessThan(a.angle);
    }

    public boolean lessThanOrEquals(Angle a) {
        return this.lessThanOrEquals(a.angle);
    }

    public double getAngle() {
        return this.adjust(this.angle);
    }

    public double getRadian() {
        return this.adjust(this.angle);
    }

    public double getDegrees() {
        return this.adjust(this.angle) * 57.29577951308232;
    }

    public void putDegrees(double a) {
        this.angle = a / 57.29577951308232;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    private double adjust(double a) {
        if (this.range == Range.UNLIMITED) {
            return a;
        }
        double temp = Angle.normalise(a);
        if (this.range == Range.UNSIGNED) {
            return temp;
        }
        if (temp > Math.PI) {
            temp -= Math.PI * 2;
        } else if (temp < -Math.PI) {
            temp += Math.PI * 2;
        }
        return temp;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        double temp = this.adjust(this.angle);
        if (this.type == Units.DEGREES) {
            s.append(temp).append(" degrees");
        } else {
            s.append(temp);
        }
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Range {
        UNLIMITED,
        UNSIGNED,
        SIGNED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Units {
        DEGREES,
        RADIANS;

    }
}

