/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

@TestClass(value="org.openscience.cdk.fingerprint.HybridizationFingerprinterTest")
public class HybridizationFingerprinter
implements IFingerprinter {
    public static final int DEFAULT_SIZE = 1024;
    public static final int DEFAULT_SEARCH_DEPTH = 8;
    private int size;
    private int searchDepth;
    static int debugCounter = 0;
    private static final Map<String, String> queryReplace = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Cl", "X");
            this.put("Br", "Z");
            this.put("Si", "Y");
            this.put("As", "D");
            this.put("Li", "L");
            this.put("Se", "E");
            this.put("Na", "G");
            this.put("Ca", "J");
            this.put("Al", "A");
        }
    };

    public HybridizationFingerprinter() {
        this(1024, 8);
    }

    public HybridizationFingerprinter(int size) {
        this(size, 8);
    }

    public HybridizationFingerprinter(int size, int searchDepth) {
        this.size = size;
        this.searchDepth = searchDepth;
    }

    @TestMethod(value="testGetFingerprint_IAtomContainer")
    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        BitSet bitSet = new BitSet(this.size);
        try {
            int[] hashes;
            IAtomContainer clonedContainer = container.clone();
            AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(clonedContainer);
            for (int hash : hashes = this.findPathes(clonedContainer, this.searchDepth)) {
                bitSet.set(new Random(hash).nextInt(this.size));
            }
        }
        catch (CloneNotSupportedException exception) {
            throw new CDKException("Exception while cloning the input: " + exception.getMessage(), (Throwable)exception);
        }
        return new BitSetFingerprint(bitSet);
    }

    protected int[] findPathes(IAtomContainer container, int searchDepth) {
        ArrayList<StringBuffer> allPaths = new ArrayList<StringBuffer>();
        HashMap<IAtom, 2> cache = new HashMap<IAtom, 2>();
        for (IAtom startAtom : container.atoms()) {
            List p = PathTools.getPathsOfLengthUpto((IAtomContainer)container, (IAtom)startAtom, (int)searchDepth);
            for (List path : p) {
                StringBuffer sb = new StringBuffer();
                IAtom x = (IAtom)path.get(0);
                if (x instanceof IPseudoAtom) {
                    sb.append('0');
                } else {
                    Integer atnum = PeriodicTable.getAtomicNumber((String)x.getSymbol());
                    if (atnum > 0) {
                        sb.append((char)atnum.intValue());
                    } else {
                        sb.append('0');
                    }
                }
                for (int i = 1; i < path.size(); ++i) {
                    final IAtom[] y = new IAtom[]{(IAtom)path.get(i)};
                    Map m = (Map)cache.get(x);
                    final IBond[] b = new IBond[]{m != null ? (IBond)m.get(y[0]) : null};
                    if (b[0] == null) {
                        b[0] = container.getBond(x, y[0]);
                        cache.put(x, new HashMap<IAtom, IBond>(){
                            static final long serialVersionUID = 1L;
                            {
                                this.put(y[0], b[0]);
                            }
                        });
                    }
                    sb.append(this.getBondSymbol(b[0]));
                    sb.append(this.convertSymbol(y[0].getSymbol()));
                    x = y[0];
                }
                StringBuffer revForm = new StringBuffer(sb);
                revForm.reverse();
                if (sb.toString().compareTo(revForm.toString()) <= 0) {
                    allPaths.add(sb);
                    continue;
                }
                allPaths.add(revForm);
            }
        }
        HashSet<String> cleanPath = new HashSet<String>();
        for (StringBuffer s : allPaths) {
            String s2;
            if (cleanPath.contains(s.toString()) || cleanPath.contains(s2 = s.reverse().toString())) continue;
            cleanPath.add(s2);
        }
        int[] hashes = new int[cleanPath.size()];
        int i = 0;
        for (String s : cleanPath) {
            hashes[i++] = s.hashCode();
        }
        return hashes;
    }

    private String convertSymbol(String symbol) {
        String returnSymbol = queryReplace.get(symbol);
        return returnSymbol == null ? symbol : returnSymbol;
    }

    protected String getBondSymbol(IBond bond) {
        String bondSymbol = "";
        if (bond.getOrder() == IBond.Order.SINGLE) {
            bondSymbol = this.isSP2Bond(bond) ? ":" : "-";
        } else if (bond.getOrder() == IBond.Order.DOUBLE) {
            bondSymbol = this.isSP2Bond(bond) ? ":" : "=";
        } else if (bond.getOrder() == IBond.Order.TRIPLE) {
            bondSymbol = "#";
        } else if (bond.getOrder() == IBond.Order.QUADRUPLE) {
            bondSymbol = "*";
        }
        return bondSymbol;
    }

    private boolean isSP2Bond(IBond bond) {
        return bond.getAtomCount() == 2 && bond.getAtom(0).getHybridization() == IAtomType.Hybridization.SP2 && bond.getAtom(1).getHybridization() == IAtomType.Hybridization.SP2;
    }

    @TestMethod(value="testGetSearchDepth")
    public int getSearchDepth() {
        return this.searchDepth;
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.size;
    }

    public Map<String, Integer> getRawFingerprint(IAtomContainer container) {
        throw new UnsupportedOperationException();
    }

    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

