/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.Arrays;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="DisjointSetForestTest")
public class DisjointSetForest {
    private int[] forest;

    @TestMethod(value="constructorTest")
    public DisjointSetForest(int numberOfElements) {
        this.forest = new int[numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            this.forest[i] = -1;
        }
    }

    @TestMethod(value="getTest")
    public int get(int i) {
        return this.forest[i];
    }

    @TestMethod(value="getRootTest")
    public int getRoot(int element) {
        if (this.forest[element] < 0) {
            return element;
        }
        return this.getRoot(this.forest[element]);
    }

    @TestMethod(value="makeUnionTest")
    public void makeUnion(int elementX, int elementY) {
        int yRoot;
        int xRoot = this.getRoot(elementX);
        if (xRoot == (yRoot = this.getRoot(elementY))) {
            return;
        }
        if (this.forest[xRoot] < this.forest[yRoot]) {
            this.forest[yRoot] = this.forest[yRoot] + this.forest[xRoot];
            this.forest[xRoot] = yRoot;
        } else {
            this.forest[xRoot] = this.forest[xRoot] + this.forest[yRoot];
            this.forest[yRoot] = xRoot;
        }
    }

    @TestMethod(value="getSetsTest")
    public int[][] getSets() {
        int n = 0;
        for (int i = 0; i < this.forest.length; ++i) {
            if (this.forest[i] >= 0) continue;
            ++n;
        }
        int[][] sets = new int[n][];
        int currentSet = 0;
        for (int i = 0; i < this.forest.length; ++i) {
            if (this.forest[i] >= 0) continue;
            int setSize = 1 - this.forest[i] - 1;
            sets[currentSet] = new int[setSize];
            int currentIndex = 0;
            for (int element = 0; element < this.forest.length; ++element) {
                if (this.getRoot(element) != i) continue;
                sets[currentSet][currentIndex] = element;
                ++currentIndex;
            }
            ++currentSet;
        }
        return sets;
    }

    public String toString() {
        return Arrays.toString(this.forest);
    }
}

