/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.IntSet;
import org.xmlcml.euclid.Line3;
import org.xmlcml.euclid.Plane3;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real3Range;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.RealSquareMatrix;
import org.xmlcml.euclid.Transform3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Point3Vector
implements EuclidConstants {
    static final Logger logger = Logger.getLogger((String)Point3Vector.class.getName());
    protected List<Point3> vector = new ArrayList<Point3>();
    private static final long serialVersionUID = 3258126964282635312L;

    public Point3Vector() {
    }

    public Point3Vector(double[] flarray) throws EuclidRuntimeException {
        this();
        if (flarray == null) {
            throw new EuclidRuntimeException("null array");
        }
        int count = 0;
        int n = flarray.length / 3;
        if (flarray.length != 3 * n) {
            throw new EuclidRuntimeException("array length must be multiple of 3");
        }
        for (int i = 0; i < n; ++i) {
            Point3 p = new Point3(flarray[count++], flarray[count++], flarray[count++]);
            this.vector.add(p);
        }
    }

    public Point3Vector(int n, double[] x, double[] y, double[] z) throws EuclidRuntimeException {
        this();
        Util.check(x, n);
        Util.check(y, n);
        Util.check(z, n);
        for (int i = 0; i < n; ++i) {
            this.vector.add(new Point3(x[i], y[i], z[i]));
        }
    }

    public Point3Vector(RealArray m) throws EuclidRuntimeException {
        this();
        double[] marray = m.getArray();
        int count = marray.length / 3;
        if (marray == null || marray.length != count * 3) {
            throw new EuclidRuntimeException("null array or count not divisible by 3");
        }
        int j = 0;
        for (int i = 0; i < count; ++i) {
            this.vector.add(new Point3(marray[j++], marray[j++], marray[j++]));
        }
    }

    public Point3Vector(Point3Vector pv) {
        this();
        for (int i = 0; i < pv.size(); ++i) {
            Point3 point = pv.elementAt(i);
            if (point != null) {
                point = new Point3(point);
            }
            this.addElement(point);
        }
    }

    public int size() {
        return this.vector.size();
    }

    public List<Point3> getPoint3List() {
        return this.vector;
    }

    public boolean isEqualTo(Point3Vector p) {
        boolean ok = true;
        if (p == null || this.size() != p.size()) {
            ok = false;
        } else {
            int i = 0;
            for (Point3 pp : p.vector) {
                Point3 thisP;
                if ((thisP = this.vector.get(i++)).isEqualTo(pp)) continue;
                ok = false;
                break;
            }
        }
        return ok;
    }

    public double[] getArray() {
        double[] array = new double[3 * this.vector.size()];
        int i = 0;
        for (Point3 p : this.vector) {
            array[i++] = p.flarray[0];
            array[i++] = p.flarray[1];
            array[i++] = p.flarray[2];
        }
        return array;
    }

    public void add(Point3 p) {
        this.vector.add(p);
    }

    public void setElementAt(Point3 p, int i) {
        this.vector.set(i, p);
    }

    public Point3 elementAt(int i) {
        return this.vector.get(i);
    }

    public Point3 get(int i) {
        return this.vector.get(i);
    }

    private void checkConformable(Point3Vector v) throws EuclidRuntimeException {
        if (this.size() != v.size()) {
            throw new EuclidRuntimeException("incompatible Point3Vector sizes: " + this.size() + "/" + v.size());
        }
    }

    public void addElement(Point3 p) {
        this.vector.add(p);
    }

    public void setElementAt(Vector3 v, int i) throws EuclidRuntimeException {
        this.vector.set(i, new Point3(v));
    }

    public RealRange getRange(Axis.Axis3 ax) {
        RealArray temp = new RealArray(this.vector.size());
        double[] dd = temp.getArray();
        int i = 0;
        for (Point3 p : this.vector) {
            dd[i++] = p.getArray()[ax.value];
        }
        RealRange range = new RealRange();
        if (this.size() > 0) {
            range.add(temp.smallestElement());
            range.add(temp.largestElement());
        }
        return range;
    }

    public Real3Range getRange3() {
        Axis.Axis3[] axes = Axis.Axis3.values();
        Real3Range range = new Real3Range();
        for (Axis.Axis3 ax : axes) {
            range.add(ax, this.getRange(ax));
        }
        return range;
    }

    public double getSigmaDeltaSquared(Point3Vector v) throws EuclidRuntimeException {
        int np = this.size();
        if (v.size() != np) {
            throw new EuclidRuntimeException("Vectors of different lengths");
        }
        double d = 0.0;
        for (int i = 0; i < np; ++i) {
            Point3 thisP = this.vector.get(i);
            Point3 vP = v.vector.get(i);
            double dist = thisP.getDistanceFromPoint(vP);
            d += dist * dist;
        }
        return d;
    }

    public Point3Vector subArray(IntSet is) throws EuclidRuntimeException {
        Point3Vector sub = new Point3Vector();
        for (int i = 0; i < is.size(); ++i) {
            int ix = is.elementAt(i);
            if (ix < 0 || ix >= this.size()) {
                throw new EuclidRuntimeException("element out of range: " + ix);
            }
            sub.addElement(new Point3(this.getPoint3(ix)));
        }
        return sub;
    }

    public Point3Vector multiplyBy(double scale) {
        Point3Vector p3v = new Point3Vector(this);
        p3v.multiplyByEquals(scale);
        return p3v;
    }

    public void multiplyByEquals(double scale) {
        for (int i = 0; i < this.size(); ++i) {
            this.getPoint3(i).multiplyEquals(scale);
        }
    }

    public Point3Vector plus(Point3Vector pv2) throws EuclidRuntimeException {
        this.checkConformable(pv2);
        Point3Vector pv1 = new Point3Vector();
        for (int i = 0; i < this.size(); ++i) {
            Point3 temp = this.getPoint3(i).plus(pv2.getPoint3(i));
            pv1.addElement(temp);
        }
        return pv1;
    }

    public Point3Vector subtract(Point3Vector pv2) throws EuclidRuntimeException {
        this.checkConformable(pv2);
        Point3Vector pv1 = new Point3Vector();
        for (int i = 0; i < this.size(); ++i) {
            Vector3 v = this.getPoint3(i).subtract(pv2.getPoint3(i));
            Point3 temp = new Point3(v.getArray());
            pv1.addElement(temp);
        }
        return pv1;
    }

    public Line3 getLine(int i1, int i2) {
        Line3 temp = new Line3();
        if (i1 >= 0 && i1 < this.size() && i2 >= 0 && i2 < this.size()) {
            temp = new Line3(this.getPoint3(i1), this.getPoint3(i2));
        }
        return temp;
    }

    public synchronized Point3 getCentroid() {
        int size = this.size();
        if (size < 1) {
            return null;
        }
        Point3 p = new Point3();
        for (int j = size - 1; j >= 0; --j) {
            p = p.plus(this.getPoint3(j));
        }
        double scale = 1.0 / (double)size;
        p = p.multiplyBy(scale);
        return p;
    }

    public Point3Vector plus(Vector3 v) {
        Point3Vector temp = new Point3Vector();
        for (int i = 0; i < this.size(); ++i) {
            Point3 p = this.getPoint3(i).plus(v);
            temp.addElement(p);
        }
        return temp;
    }

    public void plusEquals(Vector3 v) {
        for (int i = 0; i < this.size(); ++i) {
            this.getPoint3(i).plusEquals(v);
        }
    }

    public Point3Vector subtract(Vector3 v) {
        Vector3 v1 = v.negative();
        Point3Vector temp = this.plus(v1);
        return temp;
    }

    public void moveToCentroid() {
        Point3 temp = this.getCentroid();
        temp = temp.multiplyBy(-1.0);
        this.plusEquals(new Vector3(temp));
    }

    public static void removeNullValues(Point3Vector a, Point3Vector b) {
        int n = a.size();
        if (b.size() != n) {
            throw new EuclidRuntimeException("vectors of different sizes");
        }
        for (int i = n - 1; i >= 0; --i) {
            Point3 pa = a.elementAt(i);
            Point3 pb = b.elementAt(i);
            if (pa != null && pb != null) continue;
            if (pa == null && pb == null) {
                a.vector.remove(i);
                b.vector.remove(i);
                continue;
            }
            throw new EuclidRuntimeException("unmatched null values at: " + i);
        }
    }

    public RealSquareMatrix calculateNonMassWeightedInertialTensorOld() {
        RealSquareMatrix tensor = new RealSquareMatrix(3);
        Point3 centre = this.getCentroid();
        for (int i = 0; i < this.size(); ++i) {
            Point3 temp = new Point3(this.getPoint3(i).subtract(centre));
            RealArray delta = new RealArray(3, temp.getArray());
            RealSquareMatrix op = RealSquareMatrix.outerProduct(delta);
            tensor = tensor.plus(op);
        }
        return tensor;
    }

    public RealSquareMatrix calculateRotationToInertialAxes() {
        RealSquareMatrix inertialTensor = this.calculateNonMassWeightedInertialTensor();
        RealSquareMatrix eigenvectors = inertialTensor.calculateEigenvectors();
        if (eigenvectors != null) {
            double determinant = eigenvectors.determinant();
            if (determinant < 0.1) {
                RealSquareMatrix flip = new RealSquareMatrix(new double[][]{{1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 0.0, 1.0}});
                eigenvectors = eigenvectors.multiply(flip);
            }
            eigenvectors = new RealSquareMatrix(eigenvectors.getTranspose());
        }
        return eigenvectors;
    }

    public void transform(Transform3 t) {
        for (int i = 0; i < this.size(); ++i) {
            Point3 p = new Point3(this.getPoint3(i));
            this.vector.set(i, p.transform(t));
        }
    }

    public void transform(Transform3 t, IntSet is) {
        int nis = is.size();
        for (int j = 0; j < nis; ++j) {
            int i = is.elementAt(j);
            if (i < 0 || i >= this.size()) continue;
            Point3 p = new Point3(this.getPoint3(i));
            this.vector.set(i, p.transform(t));
        }
    }

    public double distance(int i1, int i2) {
        Vector3 v1 = this.getPoint3(i1).subtract(this.getPoint3(i2));
        return v1.getLength();
    }

    public double distance(IntSet is) throws EuclidRuntimeException {
        if (is.size() != 2) {
            throw new EuclidRuntimeException("int set must have exactly 2 points");
        }
        return this.distance(is.elementAt(0), is.elementAt(1));
    }

    public Angle angle(int i1, int i2, int i3) throws EuclidRuntimeException {
        Angle a = Point3.getAngle(this.getPoint3(i1), this.getPoint3(i2), this.getPoint3(i3));
        return a;
    }

    public Angle angle(IntSet is) throws EuclidRuntimeException {
        if (is.size() != 3) {
            throw new EuclidRuntimeException("size must be 3");
        }
        return this.angle(is.elementAt(0), is.elementAt(1), is.elementAt(2));
    }

    public Angle torsion(int i1, int i2, int i3, int i4) throws EuclidRuntimeException {
        return Point3.getTorsion(this.getPoint3(i1), this.getPoint3(i2), this.getPoint3(i3), this.getPoint3(i4));
    }

    public Angle torsion(IntSet is) throws EuclidRuntimeException {
        if (is.size() != 4) {
            throw new EuclidRuntimeException("size must be 4");
        }
        return this.torsion(is.elementAt(0), is.elementAt(1), is.elementAt(2), is.elementAt(3));
    }

    public RealSquareMatrix getDistanceMatrix() {
        int size = this.size();
        RealSquareMatrix distances = new RealSquareMatrix(size);
        double zero = 0.0;
        double[][] distanceMatrix = distances.getMatrix();
        for (int i = 0; i < size; ++i) {
            distanceMatrix[i][i] = zero;
            for (int j = i + 1; j < size; ++j) {
                double distance;
                distanceMatrix[i][j] = distance = this.getPoint3(i).getDistanceFromPoint(this.getPoint3(j));
                distanceMatrix[j][i] = distance;
            }
        }
        return distances;
    }

    public RealSquareMatrix calculateNonMassWeightedInertialTensor() {
        RealSquareMatrix rsm = new RealSquareMatrix(3);
        for (int i = 0; i < this.size(); ++i) {
            Point3 p = this.get(i);
            double x = p.getArray()[0];
            double y = p.getArray()[1];
            double z = p.getArray()[2];
            double[] dArray = rsm.flmat[0];
            dArray[0] = dArray[0] + (y * y + z * z);
            double[] dArray2 = rsm.flmat[1];
            dArray2[1] = dArray2[1] + (x * x + z * z);
            double[] dArray3 = rsm.flmat[2];
            dArray3[2] = dArray3[2] + (y * y + x * x);
            double[] dArray4 = rsm.flmat[0];
            dArray4[1] = dArray4[1] + -x * y;
            double[] dArray5 = rsm.flmat[0];
            dArray5[2] = dArray5[2] + -x * z;
            double[] dArray6 = rsm.flmat[1];
            dArray6[2] = dArray6[2] + -y * z;
            rsm.flmat[1][0] = rsm.flmat[0][1];
            rsm.flmat[2][0] = rsm.flmat[0][2];
            rsm.flmat[2][1] = rsm.flmat[1][2];
        }
        return rsm;
    }

    public void inertialAxes(RealArray eigval, RealSquareMatrix eigvect, EuclidRuntimeException illCond) throws EuclidRuntimeException {
        RealArray val = new RealArray(3);
        RealSquareMatrix vect = new RealSquareMatrix(3);
        illCond = null;
        eigval.shallowCopy(val);
        eigvect.shallowCopy(vect);
    }

    public Plane3 bestPlane() throws EuclidRuntimeException {
        RealSquareMatrix eigvect = new RealSquareMatrix(3);
        RealArray eigval = new RealArray(3);
        EuclidRuntimeException illCond = null;
        this.inertialAxes(eigval, eigvect, illCond);
        RealArray temp = eigvect.extractRowData(2);
        Vector3 v = new Vector3(temp);
        double dist = v.dot(this.getCentroid().getArray());
        Plane3 p = new Plane3(v, dist);
        return p;
    }

    public RealArray deviationsFromPlane(Plane3 p) {
        double[] farray = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            double dist = p.getVector().dot(this.getPoint3(i).getArray());
            farray[i] = dist -= p.getDistance();
        }
        return new RealArray(farray);
    }

    public Point3 getPoint3(int i) {
        return this.vector.get(i);
    }

    public RealArray getXYZ() {
        double[] f = new double[3 * this.size()];
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            double[] p = this.getPoint3((int)i).flarray;
            f[count++] = p[0];
            f[count++] = p[1];
            f[count++] = p[2];
        }
        return new RealArray(f);
    }

    public double getCoordinate(int i, Axis.Axis3 j) {
        return this.getPoint3((int)i).flarray[j.value];
    }

    double getCoordinate(int i, int j) {
        return this.getPoint3((int)i).flarray[j];
    }

    public RealArray getXYZ(Axis.Axis3 axis) {
        double[] f = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            f[i] = this.getPoint3((int)i).flarray[axis.value];
        }
        return new RealArray(f);
    }

    public double rms(Point3Vector c) {
        RealArray tt = this.getXYZ();
        RealArray cc = c.getXYZ();
        tt = tt.subtract(cc);
        return Math.sqrt(tt.innerProduct()) / new Double(this.size());
    }

    public int getFurthestPointFrom(Point3 p) {
        double d = -0.1;
        int serial = -1;
        for (int i = 0; i < this.size(); ++i) {
            Point3 pp = this.vector.get(i);
            double dd = p.getDistanceFromPoint(pp);
            if (!(dd > d)) continue;
            d = dd;
            serial = i;
        }
        return serial;
    }

    public int getPointMakingSmallestAngle(Point3 p1, Point3 p2) {
        double a = 999.0;
        int serial = -1;
        for (int i = 0; i < this.size(); ++i) {
            Point3 pp = this.vector.get(i);
            if (pp.isEqualTo(p1) || pp.isEqualTo(p2)) continue;
            try {
                Angle ang = Point3.getAngle(p1, pp, p2);
                double aa = ang.getAngle();
                if (!(aa < a)) continue;
                a = aa;
                serial = i;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return serial;
    }

    public Transform3 alignUsing3Points(Point3Vector ref) throws EuclidRuntimeException {
        if (this.size() != ref.size()) {
            throw new EuclidRuntimeException("this and ref must be same size");
        }
        if (this.size() < 3) {
            throw new EuclidRuntimeException("Need at least 3 points");
        }
        int[] serial = this.get3SeparatedPoints();
        Point3Vector thisVector = new Point3Vector();
        Point3Vector refVector = new Point3Vector();
        for (int i = 0; i < serial.length; ++i) {
            thisVector.add(this.getPoint3(serial[i]));
            refVector.add(ref.getPoint3(serial[i]));
        }
        return thisVector.align3PointVectors(refVector);
    }

    public int[] get3SeparatedPoints() throws EuclidRuntimeException {
        int[] serial = new int[3];
        Point3 c1 = this.getCentroid();
        serial[0] = this.getFurthestPointFrom(c1);
        Point3 p1 = this.getPoint3(serial[0]);
        serial[1] = this.getFurthestPointFrom(p1);
        Point3 p2 = this.getPoint3(serial[1]);
        if (p1.isEqualTo(p2)) {
            throw new EuclidRuntimeException("Cannot find 3 separated points");
        }
        serial[2] = this.getPointMakingSmallestAngle(p1, p2);
        Point3 p3 = this.getPoint3(serial[2]);
        if (p1.isEqualTo(p3) || p2.isEqualTo(p3)) {
            throw new EuclidRuntimeException("Cannot find 3 separated points");
        }
        if (p3.subtract(p1).cross(p3.subtract(p2)).isZero()) {
            throw new EuclidRuntimeException("Cannot find 3 non-colinear points");
        }
        return serial;
    }

    public Transform3 align3PointVectors(Point3Vector ref) throws EuclidRuntimeException {
        if (this.size() != 3) {
            throw new EuclidRuntimeException("this requires 3 points");
        }
        if (ref.size() != 3) {
            throw new EuclidRuntimeException("ref requires 3 points");
        }
        RealSquareMatrix unit = new RealSquareMatrix(3, new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
        Transform3 overallTransform = new Transform3(unit);
        Point3Vector moving = new Point3Vector(this);
        Point3 thisCentroid = moving.getCentroid();
        Point3 refCentroid = ref.getCentroid();
        Point3 p1 = moving.getPoint3(0);
        Point3 p2 = moving.getPoint3(1);
        Point3 r1 = ref.getPoint3(0);
        Vector3 p12 = p1.subtract(thisCentroid);
        Vector3 r12 = r1.subtract(refCentroid);
        Transform3 rot = new Transform3(p12, r12);
        moving.transform(rot);
        p1 = moving.getPoint3(0);
        p2 = moving.getPoint3(1);
        overallTransform = rot.concatenate(overallTransform);
        p12 = p1.subtract(p2);
        Point3 p3 = moving.getPoint3(2);
        Point3 r3 = ref.getPoint3(2);
        Vector3 p13 = p3.subtract(thisCentroid);
        Vector3 r13 = r3.subtract(refCentroid);
        Vector3 px = p12.cross(p13);
        px = px.normalize();
        Vector3 rx = r12.cross(r13);
        rx = rx.normalize();
        Transform3 rotx = new Transform3(px, rx);
        overallTransform = rotx.concatenate(overallTransform);
        return overallTransform;
    }

    public Transform3 roughAlign(Point3Vector ref) throws EuclidRuntimeException {
        int nn = ref.size();
        if (nn != this.size()) {
            throw new EuclidRuntimeException("arrays of different lengths: " + this.size() + "/" + nn);
        }
        if (nn < 3) {
            throw new EuclidRuntimeException("must have 3 points to align: " + this.size() + "/" + nn);
        }
        Point3 centThis = this.getCentroid();
        Point3 centRef = ref.getCentroid();
        Transform3 r = this.fit3Points(ref);
        return this.translateRotateRetranslate(centThis, centRef, r);
    }

    private Transform3 fit3Points(Point3Vector ref) {
        Point3Vector pvThis = new Point3Vector(this);
        pvThis.moveToCentroid();
        Point3Vector pvRef = new Point3Vector(ref);
        pvRef.moveToCentroid();
        int[] points = this.get3SeparatedPoints();
        Transform3 tThis = this.getTransformOfPlane(points, pvThis);
        Transform3 tRef = this.getTransformOfPlane(points, pvRef);
        tRef.transpose();
        Transform3 r = tRef.concatenate(tThis);
        return r;
    }

    private Transform3 translateRotateRetranslate(Point3 centThis, Point3 centRef, Transform3 rotate) {
        Vector3 this2Origv = new Vector3(centThis.multiplyBy(-1.0));
        Transform3 trans2Orig = new Transform3(this2Origv);
        Transform3 trans1 = rotate.concatenate(trans2Orig);
        Vector3 orig2Refv = new Vector3(centRef);
        Transform3 orig2Ref = new Transform3(orig2Refv);
        Transform3 finalT = orig2Ref.concatenate(trans1);
        return finalT;
    }

    private Transform3 getTransformOfPlane(int[] ii, Point3Vector pv) {
        Plane3 p = new Plane3(pv.getPoint3(ii[0]), pv.getPoint3(ii[1]), pv.getPoint3(ii[2]));
        Vector3 v = new Vector3(pv.getPoint3(ii[0])).normalize();
        Vector3 w = p.getVector().cross(v).normalize();
        Vector3 vv = v.cross(w);
        Transform3 t = new Transform3(vv, v, w);
        return t;
    }

    public Transform3 fitTo(Point3Vector ref) throws EuclidRuntimeException {
        double damp = 1.0;
        double converge = 2.0E-4;
        Point3 thisCent = this.getCentroid();
        Point3 refCent = ref.getCentroid();
        Point3Vector thistmp = new Point3Vector(this);
        Point3Vector reftmp = new Point3Vector(ref);
        thistmp.moveToCentroid();
        reftmp.moveToCentroid();
        Transform3 t = thistmp.roughAlign(reftmp);
        thistmp.transform(t);
        RealArray shift = new RealArray(3);
        int NCYC = 20;
        for (int icyc = 0; icyc < NCYC; ++icyc) {
            double maxshift = 0.0;
            for (int jax0 = 0; jax0 < 3; ++jax0) {
                int jax1 = (jax0 + 1) % 3;
                int jax2 = (jax1 + 1) % 3;
                double rh = 0.0;
                double lh = 0.0;
                for (int ipt = 0; ipt < this.size(); ++ipt) {
                    double refj1 = reftmp.getCoordinate(ipt, jax1);
                    double refj2 = reftmp.getCoordinate(ipt, jax2);
                    double movj1 = thistmp.getCoordinate(ipt, jax1);
                    double movj2 = thistmp.getCoordinate(ipt, jax2);
                    lh += refj1 * refj1 + refj2 * refj2;
                    rh += refj1 * (refj2 - movj2) - refj2 * (refj1 - movj1);
                }
                double sft = -(damp * (rh / lh));
                maxshift = Math.max(maxshift, Math.abs(sft));
                shift.setElementAt(jax0, sft);
            }
            if (maxshift < converge) break;
            if (maxshift < 0.1) {
                damp = 1.0;
            } else if (maxshift > 0.1) {
                damp = 1.0;
            }
            Transform3 t1 = new Transform3(new Angle(shift.elementAt(0)), new Angle(shift.elementAt(1)), new Angle(shift.elementAt(2)));
            thistmp.transform(t1);
            t = new Transform3(t1.concatenate(t));
        }
        Transform3 tt = this.translateRotateRetranslate(thisCent, refCent, t);
        return tt;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.get(i).toString());
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }

    public RealArray extractRealArray() {
        return new RealArray(this.getArray());
    }

    public Double innerProduct() {
        return this.extractRealArray().innerProduct();
    }
}

