/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;

public class TransitiveInfGraph
extends BaseInfGraph {
    protected TransitiveEngine transitiveEngine;
    protected Finder tbox = null;
    protected Finder dataFind;

    public TransitiveInfGraph(Graph data, TransitiveReasoner reasoner) {
        super(data, reasoner);
    }

    @Override
    public void prepare() {
        this.tbox = ((TransitiveReasoner)this.reasoner).getTbox();
        this.transitiveEngine = new TransitiveEngine(((TransitiveReasoner)this.reasoner).getSubClassCache().deepCopy(), ((TransitiveReasoner)this.reasoner).getSubPropertyCache().deepCopy());
        this.dataFind = this.transitiveEngine.insert(this.tbox, this.fdata);
        this.transitiveEngine.setCaching(true, true);
        this.isPrepared = true;
    }

    @Override
    public Graph getSchemaGraph() {
        if (this.tbox == null) {
            return null;
        }
        if (this.tbox instanceof FGraph) {
            return ((FGraph)this.tbox).getGraph();
        }
        throw new ReasonerException("Transitive reasoner got into an illegal state");
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        Finder cascade = this.transitiveEngine.getFinder(pattern, FinderUtil.cascade(this.tbox, continuation));
        return UniqueExtendedIterator.create(cascade.find(pattern));
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), this.fdata);
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, this.fdata);
    }

    @Override
    public synchronized void performAdd(Triple t) {
        if (!this.isPrepared) {
            this.prepare();
        }
        this.fdata.getGraph().add(t);
        this.transitiveEngine.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        if (this.isPrepared) {
            this.transitiveEngine.delete(t);
        }
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }
}

