/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.config.BODRIsotope;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Isotopes
extends IsotopeFactory {
    private static Isotopes myself = null;

    public static Isotopes getInstance() throws IOException {
        if (myself == null) {
            myself = new Isotopes();
        }
        return myself;
    }

    private Isotopes() throws IOException {
        String configFile = "org/openscience/cdk/config/data/isotopes.dat";
        this.isotopes = new HashMap();
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(configFile);
        int streamSize = ins.available();
        ReadableByteChannel fcIn = Channels.newChannel(ins);
        ByteBuffer bin = ByteBuffer.allocate(streamSize);
        fcIn.read(bin);
        fcIn.close();
        ins.close();
        bin.position(0);
        int isotopeCount = bin.getInt();
        for (int i = 0; i < isotopeCount; ++i) {
            byte atomicNum = bin.get();
            short massNum = bin.getShort();
            double exactMass = bin.getDouble();
            double natAbund = bin.get() == 1 ? bin.getDouble() : 0.0;
            BODRIsotope isotope = new BODRIsotope(PeriodicTable.getSymbol(atomicNum), Integer.valueOf(atomicNum), Integer.valueOf(massNum), exactMass, natAbund);
            this.add(isotope);
        }
        this.majorIsotopes = new HashMap();
    }

    @Override
    public IIsotope[] getIsotopes(String symbol) {
        if (this.isotopes.get(symbol) == null) {
            return new IIsotope[0];
        }
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (IIsotope isotope : (List)this.isotopes.get(symbol)) {
            if (!isotope.getSymbol().equals(symbol)) continue;
            list.add(isotope);
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    @Override
    public IIsotope[] getIsotopes() {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (String element : this.isotopes.keySet()) {
            for (IIsotope isotope : (List)this.isotopes.get(element)) {
                list.add(isotope);
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    @Override
    public IIsotope[] getIsotopes(double exactMass, double difference) {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (String element : this.isotopes.keySet()) {
            for (IIsotope isotope : (List)this.isotopes.get(element)) {
                if (!(Math.abs(isotope.getExactMass() - exactMass) <= difference)) continue;
                list.add(isotope);
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    @Override
    public IIsotope getIsotope(String symbol, int massNumber) {
        if (this.isotopes.get(symbol) == null) {
            return null;
        }
        for (IIsotope isotope : (List)this.isotopes.get(symbol)) {
            if (!isotope.getSymbol().equals(symbol) || isotope.getMassNumber() != massNumber) continue;
            return isotope;
        }
        return null;
    }

    @Override
    public IIsotope getIsotope(String symbol, double exactMass, double tolerance) {
        if (this.isotopes.get(symbol) == null) {
            return null;
        }
        IIsotope ret = null;
        double minDiff = Double.MAX_VALUE;
        for (IIsotope isotope : (List)this.isotopes.get(symbol)) {
            double diff = Math.abs(isotope.getExactMass() - exactMass);
            if (!isotope.getSymbol().equals(symbol) || !(diff <= tolerance) || !(diff < minDiff)) continue;
            ret = isotope;
            minDiff = diff;
        }
        return ret;
    }

    @Override
    public IIsotope getMajorIsotope(int atomicNumber) {
        if (this.isotopes.get(PeriodicTable.getSymbol(atomicNumber)) == null) {
            return null;
        }
        IIsotope major = null;
        for (IIsotope isotope : (List)this.isotopes.get(PeriodicTable.getSymbol(atomicNumber))) {
            if (isotope.getAtomicNumber() != atomicNumber || major != null && !(isotope.getNaturalAbundance() > major.getNaturalAbundance())) continue;
            major = isotope;
        }
        if (major == null) {
            logger.error("Could not find major isotope for: ", atomicNumber);
        }
        return major;
    }

    @Override
    public IIsotope getMajorIsotope(String symbol) {
        IIsotope major = null;
        if (this.majorIsotopes.containsKey(symbol)) {
            major = (IIsotope)this.majorIsotopes.get(symbol);
        } else {
            if (this.isotopes.get(symbol) == null) {
                logger.error("Could not find major isotope for: ", symbol);
                return null;
            }
            for (IIsotope isotope : (List)this.isotopes.get(symbol)) {
                if (!isotope.getSymbol().equals(symbol) || major != null && !(isotope.getNaturalAbundance() > major.getNaturalAbundance())) continue;
                major = isotope;
            }
            if (major == null) {
                logger.error("Could not find major isotope for: ", symbol);
            } else {
                this.majorIsotopes.put(symbol, major);
            }
        }
        return major;
    }
}

