/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import org.openscience.cdk.formula.DecomposerFactory;
import org.openscience.cdk.formula.IFormulaGenerator;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.formula.RangeMassDecomposer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;

class RoundRobinFormulaGenerator
implements IFormulaGenerator {
    protected final IChemObjectBuilder builder;
    protected final RangeMassDecomposer.DecompIterator decomposer;
    protected final MolecularFormulaRange mfRange;
    protected volatile int[] lastDecomposition;
    protected volatile boolean done;

    RoundRobinFormulaGenerator(IChemObjectBuilder builder, double minMass, double maxMass, MolecularFormulaRange mfRange) {
        this.builder = builder;
        ArrayList<IIsotope> isotopes = new ArrayList<IIsotope>(mfRange.getIsotopeCount());
        for (IIsotope iso : mfRange.isotopes()) {
            if (mfRange.getIsotopeCountMin(iso) < 0 || mfRange.getIsotopeCountMax(iso) <= 0) continue;
            isotopes.add(iso);
        }
        this.decomposer = DecomposerFactory.getInstance().getDecomposerFor(isotopes.toArray(new IIsotope[isotopes.size()])).decomposeIterator(minMass, maxMass, mfRange);
        this.done = false;
        this.mfRange = mfRange;
    }

    @Override
    public synchronized IMolecularFormula getNextFormula() {
        if (!this.done && this.decomposer.next()) {
            this.lastDecomposition = this.decomposer.getCurrentCompomere();
            return this.decomposer.generateCurrentMolecularFormula(this.builder);
        }
        this.done = true;
        return null;
    }

    @Override
    public synchronized IMolecularFormulaSet getAllFormulas() {
        IMolecularFormulaSet set = this.builder.newInstance(IMolecularFormulaSet.class, new Object[0]);
        if (this.done) {
            return set;
        }
        IMolecularFormula formula = this.getNextFormula();
        while (formula != null) {
            set.addMolecularFormula(formula);
            if (this.done) {
                return set;
            }
            formula = this.getNextFormula();
        }
        this.done = true;
        return set;
    }

    @Override
    public double getFinishedPercentage() {
        if (this.done) {
            return 1.0;
        }
        int[] lastDecomposition = this.lastDecomposition;
        if (lastDecomposition == null) {
            return 0.0;
        }
        double result = 0.0;
        double remainingPerc = 1.0;
        for (int i = lastDecomposition.length - 1; i >= 0; --i) {
            double max = this.mfRange.getIsotopeCountMax(this.decomposer.weights.get(i).getOwner());
            if (i > 0) {
                max += 1.0;
            }
            result += remainingPerc * ((double)lastDecomposition[i] / max);
            remainingPerc /= max;
        }
        return result;
    }

    @Override
    public void cancel() {
        this.done = true;
    }
}

