/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class PDBFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new PDBFormat();
        }
        return myself;
    }

    @Override
    public String getFormatName() {
        return "Protein Brookhave Database (PDB)";
    }

    @Override
    public String getMIMEType() {
        return "chemical/x-pdb";
    }

    @Override
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    public String[] getNameExtensions() {
        return new String[]{"pdb", "ent"};
    }

    @Override
    public String getReaderClassName() {
        return "org.openscience.cdk.io.PDBReader";
    }

    @Override
    public String getWriterClassName() {
        return "org.openscience.cdk.io.PDBWriter";
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.startsWith("HEADER") || line.startsWith("HETATM ") || line.startsWith("ATOM  ");
    }

    @Override
    public boolean isXMLBased() {
        return false;
    }

    @Override
    public int getSupportedDataFeatures() {
        return 4 | this.getRequiredDataFeatures();
    }

    @Override
    public int getRequiredDataFeatures() {
        return 10;
    }
}

