/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openscience.cdk.ConformerContainer;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.iterator.IteratingSDFReader;

public class IteratingMDLConformerReader
implements Iterator {
    private IteratingSDFReader imdlr;
    private ConformerContainer container;
    private IAtomContainer lastMol = null;
    private boolean hasNext = false;
    private boolean nextIsKnown = false;

    public IteratingMDLConformerReader(Reader in, IChemObjectBuilder builder) {
        this.imdlr = new IteratingSDFReader(in, builder);
        this.container = new ConformerContainer();
    }

    public IteratingMDLConformerReader(InputStream in, IChemObjectBuilder builder) {
        this.imdlr = new IteratingSDFReader(in, builder);
        this.container = new ConformerContainer();
    }

    @Override
    public boolean hasNext() {
        boolean slurpedConformers = false;
        if (this.lastMol != null) {
            this.container = new ConformerContainer(this.lastMol);
        }
        if (!this.nextIsKnown) {
            while (this.imdlr.hasNext()) {
                slurpedConformers = true;
                IAtomContainer mol = this.imdlr.next();
                if (this.container.size() == 0) {
                    this.container.add(mol);
                    continue;
                }
                if (this.container.getTitle().equals(mol.getProperty("cdk:Title"))) {
                    this.container.add(mol);
                    continue;
                }
                this.lastMol = mol;
                this.hasNext = true;
                break;
            }
            boolean bl = this.hasNext = this.container.size() > 0 && slurpedConformers;
        }
        if (!this.hasNext) {
            this.container = null;
        }
        this.nextIsKnown = true;
        return this.hasNext;
    }

    public Object next() {
        if (!this.nextIsKnown) {
            this.hasNext();
        }
        this.nextIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.container;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

