/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.HashSet;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class AtomTypeTools {
    public static final int PYROLE_RING = 4;
    public static final int FURAN_RING = 6;
    public static final int THIOPHENE_RING = 8;
    public static final int PYRIDINE_RING = 10;
    public static final int PYRIMIDINE_RING = 12;
    public static final int BENZENE_RING = 5;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomTypeTools.class);
    HOSECodeGenerator hcg = new HOSECodeGenerator();
    SmilesGenerator sg = null;
    private String PYRROLE_SMI = null;
    private String FURAN_SMI = null;
    private String THIOPHENE_SMI = null;
    private String PYRIDINE_SMI = null;
    private String PYRIMIDINE_SMI = null;
    private String BENZENE_SMI = null;

    public IRingSet assignAtomTypePropertiesToAtom(IAtomContainer molecule) throws Exception {
        return this.assignAtomTypePropertiesToAtom(molecule, true);
    }

    public IRingSet assignAtomTypePropertiesToAtom(IAtomContainer molecule, boolean aromaticity) throws Exception {
        SmilesGenerator sg = new SmilesGenerator();
        logger.debug("assignAtomTypePropertiesToAtom Start ...");
        String hoseCode = "";
        IRingSet ringSetA = null;
        IRingSet ringSetMolecule = Cycles.sssr(molecule).toRingSet();
        logger.debug(ringSetMolecule);
        if (aromaticity) {
            try {
                Aromaticity.cdkLegacy().apply(molecule);
            }
            catch (Exception cdk1) {
                logger.error("AROMATICITYError: Cannot determine aromaticity due to: " + cdk1.toString());
            }
        }
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            IAtom atom2 = molecule.getAtom(i);
            if (ringSetMolecule.contains(atom2)) {
                ringSetA = ringSetMolecule.getRings(atom2);
                RingSetManipulator.sort(ringSetA);
                IRing sring = (IRing)ringSetA.getAtomContainer(ringSetA.getAtomContainerCount() - 1);
                atom2.setProperty("cdk:Part of ring of size", sring.getRingSize());
                atom2.setProperty("cdk:Chemical Group", this.ringSystemClassifier(sring, AtomTypeTools.getSubgraphSmiles(sring, molecule)));
                atom2.setFlag(2, true);
                atom2.setFlag(8, false);
            } else {
                atom2.setProperty("cdk:Chemical Group", 4);
                atom2.setFlag(2, false);
                atom2.setFlag(8, true);
            }
            try {
                hoseCode = this.hcg.getHOSECode(molecule, atom2, 3);
                hoseCode = this.removeAromaticityFlagsFromHoseCode(hoseCode);
                atom2.setProperty("cdk:HOSE code spherical matcher", hoseCode);
                continue;
            }
            catch (CDKException ex1) {
                throw new CDKException("Could not build HOSECode from atom " + i + " due to " + ex1.toString(), ex1);
            }
        }
        return ringSetMolecule;
    }

    private static String getSubgraphSmiles(IAtomContainer subgraph, IAtomContainer molecule) throws CDKException {
        HashSet<IBond> bonds = new HashSet<IBond>();
        for (IBond bond : subgraph.bonds()) {
            bonds.add(bond);
        }
        Integer[] hCount = new Integer[subgraph.getAtomCount()];
        for (int i = 0; i < subgraph.getAtomCount(); ++i) {
            IAtom atom = subgraph.getAtom(i);
            int removed = 0;
            for (IBond bond : molecule.getConnectedBondsList(atom)) {
                if (bonds.contains(bond)) continue;
                removed += bond.getOrder().numeric().intValue();
            }
            hCount[i] = atom.getImplicitHydrogenCount();
            atom.setImplicitHydrogenCount(hCount[i] == null ? removed : hCount[i] + removed);
        }
        String smi = AtomTypeTools.cansmi(subgraph);
        for (int i = 0; i < subgraph.getAtomCount(); ++i) {
            subgraph.getAtom(i).setImplicitHydrogenCount(hCount[i]);
        }
        return smi;
    }

    private static String cansmi(IAtomContainer mol) throws CDKException {
        return SmilesGenerator.unique().create(mol);
    }

    private static String smicache(String cached, SmilesParser smipar, String input) throws CDKException {
        if (cached != null) {
            return cached;
        }
        cached = AtomTypeTools.cansmi(smipar.parseSmiles(input));
        return cached;
    }

    private int ringSystemClassifier(IRing ring, String smile) throws CDKException {
        logger.debug("Comparing ring systems: SMILES=", smile);
        SmilesParser smipar = new SmilesParser(ring.getBuilder());
        if (smile.equals(AtomTypeTools.smicache(this.PYRROLE_SMI, smipar, "c1cc[nH]c1"))) {
            return 4;
        }
        if (smile.equals(AtomTypeTools.smicache(this.FURAN_SMI, smipar, "o1cccc1"))) {
            return 6;
        }
        if (smile.equals(AtomTypeTools.smicache(this.THIOPHENE_SMI, smipar, "c1ccsc1"))) {
            return 8;
        }
        if (smile.equals(AtomTypeTools.smicache(this.PYRIDINE_SMI, smipar, "c1ccncc1"))) {
            return 10;
        }
        if (smile.equals(AtomTypeTools.smicache(this.PYRIMIDINE_SMI, smipar, "c1cncnc1"))) {
            return 12;
        }
        if (smile.equals(AtomTypeTools.smicache(this.BENZENE_SMI, smipar, "c1ccccc1"))) {
            return 5;
        }
        int ncount = 0;
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            if (!ring.getAtom(i).getSymbol().equals("N")) continue;
            ++ncount;
        }
        if (ring.getAtomCount() == 6 & ncount == 1) {
            return 10;
        }
        if (ring.getAtomCount() == 5 & ncount == 1) {
            return 4;
        }
        if (ncount == 0) {
            return 3;
        }
        return 0;
    }

    private String removeAromaticityFlagsFromHoseCode(String hoseCode) {
        String hosecode = "";
        for (int i = 0; i < hoseCode.length(); ++i) {
            if (hoseCode.charAt(i) == '*') continue;
            hosecode = hosecode + hoseCode.charAt(i);
        }
        return hosecode;
    }
}

