/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAminoAcid;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class AminoAcidManipulator {
    public static void removeAcidicOxygen(IAminoAcid acid) throws CDKException {
        if (acid.getCTerminus() == null) {
            throw new CDKException("Cannot remove oxygen: C-terminus is not defined!");
        }
        List<IBond> bonds = acid.getConnectedBondsList(acid.getCTerminus());
        for (IBond bond : bonds) {
            if (bond.getOrder() != IBond.Order.SINGLE) continue;
            for (int j = 0; j < bond.getAtomCount(); ++j) {
                if (!bond.getAtom(j).getSymbol().equals("O")) continue;
                acid.removeAtom(bond.getAtom(j));
            }
        }
    }

    public static void addAcidicOxygen(IAminoAcid acid) throws CDKException {
        if (acid.getCTerminus() == null) {
            throw new CDKException("Cannot add oxygen: C-terminus is not defined!");
        }
        IAtom acidicOxygen = acid.getBuilder().newInstance(IAtom.class, "O");
        acid.addAtom(acidicOxygen);
        acid.addBond(acid.getBuilder().newInstance(IBond.class, new Object[]{acid.getCTerminus(), acidicOxygen, IBond.Order.SINGLE}));
    }
}

